<?php
/*
 *  @template       GSM_Lepton 7 Standard
 *  @version        see info.php of this template
 *  @author         Gerard Smelt
 *  @copyright      2024-2025 ContractHulp
 *  @license        see info.php of this template
 *  @license terms  see info.php of this template
 *  @platform       see info.php of this template
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php

/* 1 The table involved */
$oFC->version [ 'setup_mod_go_party' ] = "20250810"; 
$product = "party";
/* debug * / Gsm_debug ( array ($oFC ), __LINE__  ); /* end */

/* check ifd page id is needed */
$LhulpA = LOAD_DBBASE . "_" . $product;
if ( in_array ( $LhulpA , $oFC->file_ref ) ) {
	$oFC->file_ref [ 0 ] = LOAD_DBBASE . "_" . $product;
} else { 
	$oFC->file_ref [ 0 ] = sprintf ( "%s_%s_%s", 
		LOAD_DBBASE, 
		$oFC->page_content [ 'PAGE_ID' ], 
		$product);
}	
$oFC->description .= $oFC->gsm_message ( __LINE__ ,' Create / Upgrade function started ' . $oFC->file_ref [ 0 ] ); 

/* 1B database creation if database does not exist */
$oFC->description .= $oFC->gsm_message ( __LINE__ ,$oFC->gsm_existDb ( $oFC->file_ref  [ 0 ] ));

/* 1C Modifications needed will be stored at this place */
$job = array ();
	
/* 1D which fields are present in the main file */	
$result = array ( );
$database->execute_query ( sprintf ( 'DESCRIBE %s', $oFC->file_ref [ 0 ] ),
	true, 
	$result );
/* debug */ Gsm_debug ( array ($result ), __LINE__ . $oFC->file_ref [ 0 ] ); /* end */
	
/* 1E_add /change fields not present  */
$localHulpA = array();
foreach ( $result as $row ) $localHulpA [$row [ 'Field' ]] = $row [ 'Type' ];

/* 1F wijzigen */
if ( isset ( $localHulpA[ 'id' ] ) && $localHulpA [ 'id' ] != "varchar(15)" ) {  // edit
	$job [ ] = sprintf ( "ALTER TABLE `%s` CHANGE `id` `id` varchar(15) NOT NULL", $oFC->file_ref [ 0 ] );}
if ( !isset ( $localHulpA[ 'content_long' ] ) ) {  // toevoegen
	$job [ ] = sprintf ( "ALTER TABLE `%s` ADD `content_long` varchar(4095) NOT NULL DEFAULT '' AFTER `content_short`", $oFC->file_ref [ 0 ] );}

/* 1H achtual upgrade */
if ( isset ( $job ) && count( $job ) > 0 ) {
	foreach( $job as $key => $query ) {
		$oFC->description .= $oFC->gsm_message ( __LINE__ ,$query );
		$database->simple_query ( $query );
}	}
/* 1I upgraded */

/* 1J other entries needed ? */
$oFC->description .= $oFC->gsm_message ( __LINE__ ,' Default settings checked'); 
$job = array ();

if ( !isset ( $oFC->setting [ 'zoek' ] [ $product ] ) ) {
	$main_parameter = '|type|ref|name|id|';
	$job [] = sprintf ( "INSERT INTO `%smod_go_taxonomy` ( `type`, `ref`, `name`, `active`) 
		VALUES ('zoek', '%s', '%s', '1' )",
		TABLE_PREFIX, $product, $main_parameter);
	$oFC->description .= $oFC->gsm_message ( __LINE__ , ' zoek schema toevoegd ' . $product );
	$oFC->setting [ 'zoek' ] [ $product ] = $main_parameter;
}

/* 1K achtual upgrade */
if ( isset ( $job ) && count( $job ) > 0 ) {
	foreach( $job as $key => $query ) {
		$oFC->description .= $oFC->gsm_message ( __LINE__ , ' ' . $query);
		$database->simple_query ( $query ); 
	} 
	$oFC->description .= $oFC->gsm_message ( __LINE__ , ' Default setting added'); 
}
$oFC->description .= $oFC->gsm_message ( __LINE__ ,' Upgrade function completed ' . $oFC->file_ref [ 0 ]); 
?> 