<?php
/*
 *  @template       GSM_Lepton 7 Standard
 *  @version        see info.php of this template
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this template
 *  @license terms  see info.php of this template
 *  @platform       see info.php of this template
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php

/* Module id*/ 
$module_name = LOAD_MODE. 'annuity';
$version = '20251022';
$main_file = "party";
$project = "Annuiteiten schema";
$default_template = 'ay';

/* Initialize module */
global $oLEPTON, $section_id, $database, $page_id;
$oFC = gsmoffc::getInstance();
$oTWIG = lib_twig_box::getInstance ( );
$oTWIG-> registerModule ( LOAD_MODULE . LOAD_SUFFIX );

/* Version data */
$oFC->version [ $module_name ] = $version;
$oFC->version = array_merge ( $oFC->version, $version_display);
$oFC->version [ $oFC-> language [ 'LANG' ] ] = $oFC-> language [ 'VERS' ];
$oFC->version [ "set" ] = $FC_SET [ 'version' ] ;

/* Settings */
$oFC->setting [ 'includes' ] 		= $place [ 'includes' ];
$oFC->setting [ 'frontend' ] 		= $place [ 'frontend' ];
$oFC->setting [ 'PAGE_ID' ] 		= $page_id ?? 0;
$oFC->gsm_initTaxi ( LOAD_MODULE . LOAD_SUFFIX, $oFC->user [ 'privileged' ], $FC_SET, array ( "setting", "droplet"  ) );

/* Limited use */
$oFC->page_content [ 'MODE' ] = 9;
if ( $oFC->page_content [ 'PRIVILEGED' ] > 0 ) {
	$oFC->gsm_adresDet ( $oFC->setting [ 'PAGE_ID' ], $oFC->setting [ 'owner' ] ) ;
	if ($oFC->page_content [ 'PRIVILEGED' ] > 2 ) {
		$oFC->page_content [ 'MODE' ] = 9;
		/* reload some settings */
		$oFC->gsm_initTaxi ( LOAD_MODULE . LOAD_SUFFIX, $oFC->page_content [ 'PRIVILEGED' ], $FC_SET, "setting" );
}	}

/* File references */
$oFC->file_ref [ 99 ] = sprintf ( "%s_%s_%s", 
	LOAD_DBBASE, 
	$oFC->setting [ 'PAGE_ID' ], 
	$main_file);
	
/* Default values */
$oFC->page_content [ 'MODULE' ] = $module_name;
$oFC->page_content [ 'PAGE_ID' ] = $oFC->setting [ 'PAGE_ID' ];
$oFC->page_content [ 'SECTION_ID' ] = $section_id ?? 0;
/* $project= sprintf ("%s ( %s )" , $project, $oFC->page_content [ 'PAGE_ID' ] ) ; */

$oFC->page_content [ 'FORMULIER' ] = $project;
$oFC->page_content [ 'ICON' ] = 'calculator icon';
$template_name= '@' . LOAD_MODULE . LOAD_SUFFIX . "/". LANGUAGE . sprintf ("/%s%s_form.lte", 
	$oFC->setting [ 'PAGE_ID' ], 
	$default_template);





$oFC->page_content [ 'pdf_location' ] = sprintf ( "%s/%s/XX_%s/", $oFC->setting [ 'collectdir' ], date ("Y_m_d"), session_id ( ) );

$check = $oFC->setting [ 'includes' ] . 'v'.substr ( $module_name , 1 ) . '_check' . '1' . '.php';

	
/* Create condition for sips test */
$_SESSION [ 'page_h' ] = $oFC->page_content ['HASH'];

/* debug * / Gsm_debug (array ( "post"=>		 $_POST, "get"=>$_GET ?? "", $xmode , $selection ), __LINE__ . "post" ); /* end */
/* debug * / Gsm_debug (array ( "user"=>	$oFC->user ), __LINE__ . "user" ); /* end */ 
/* debug * / Gsm_debug (array ( "setting"=>	$oFC->setting  ), __LINE__ ."setting" ); /* end */ 
/* debug * / Gsm_debug (array ( "files"=>	$oFC->file_ref  ), __LINE__ . "files" ); /* end */ 
/* debug * / Gsm_debug (array ( "talen"=>	$oFC->language  ), __LINE__ . "talen" ); /* end */
/* debug * / Gsm_debug (array ( "content"=>	$oFC->page_content ), __LINE__ . "content" ); /* end */ 

/* Selection  functions */
if ( !isset ( $xmode ) ) $xmode = "";
if ( !isset ( $selection ) ) $selection = "";
/* check input for keywords */
$oFC->gsm_validateSelection ( $selection, $xmode, array ( "print1" => "print1"  ,  "print" => "print" ) );
/* use remainder of input to create search string */
$oFC->search_mysql = $oFC->gsm_validateSelection2 ( $selection, $oFC->page_content );

/* Sips test before job */ 
if ( isset( $_POST[ 'command' ] ) && $oFC->sips) { 
	unset ($_POST); 
	$oFC->description .=  $oFC->gsm_message ( __LINE__ , $oFC->language [ 'TXT_ERROR_SIPS' ] ); 
}

/* reset before job */ 
if ( isset( $_POST[ 'command' ] ) && $_POST [ 'command' ] == "Reset" ) { 
	unset ($_POST); 
	$oFC->description .= $oFC->gsm_message ( __LINE__ , $oFC->language [ 'TXT_REMOVE_INPUT' ] ); 
}

/* oeps Print public function */
if ( strstr ( $xmode, "print") )
	$oFC->setting ['pdf_filename'] = $oFC->gsm_sanitizeStringS ( str_replace ( " .", ".", sprintf ( "Overzicht %s %s.%s", 
		$main_file ?? $default_prefix,  
		$oFC->page_content  [ 'PARAMETER' ] , 
		"pdf")) , "s{FILE}" );

/*  which job to do */
if ( isset( $_POST[ 'command' ] ) ) {
	$oFC->page_content [ 'P1' ] = false; // niet eerste cycle 
	foreach ($_POST as $pay =>$load ) {	
		/* evaluate inputstring "gsm_" */ 
		if (substr ( $pay, 0, 4 ) == "gsm_" ) {
			$oFC->page_content [ substr ( $pay, 4 ) ] = $oFC->gsm_sanitizeStringS ( $load ?? "" , "s{INPUT}" );
		
		/* "gsma_", "gsmb_"	couple */
		} elseif (substr ( $pay, 0, 5 ) == "gsma_" ) {
			$payb = str_replace ( "gsma_", "gsmb_", $pay);
			$loadb = ( isset ($_POST [ $payb ] ) ) ? $_POST [ $payb ] : 0;
			$oFC->page_content [ substr ( $pay, 5 , 4) ] [ $load ] = $oFC->gsm_sanitizeStringV ( $loadb , "v{0;-50000;50000}" );
	}	}
	
	/* read stored items to  select */
	if ( isset ( $oFC->page_content [ 'd001' ]) && !isset ( $_POST[ 'gsm_d011' ] ) ) {
		/* get record if any */
		$oFC->gsm_selectionRead ($oFC->page_content, $oFC->file_ref [ 99 ] );
	}
 
	/* checks op inhoud */ 
	$oFC->gsm_validateCheck 	( $oFC->page_content, $oFC->user, $oFC->file_ref [ 99 ] );

	/* jobs */	
	switch ( $_POST [ 'command' ] ) {
		case "Reset":
			$oFC->page_content [ 'MODE' ] = 9;
			$oFC->page_content [ 'P1' ] = true; // eerste cycle 
			break;
		case "Email":
			$template="mail_calculation.php";
			$attachments = array ( LEPTON_PATH . $_POST [ "gsmx_payload" ] => "annuity report.pdf" );
			$parseArr = array( );
			$parseArr [ 'WEB_MASTER' ] =  MAILER_DEFAULT_SENDERNAME;
			$parseArr [ 'WEB_EMAIL' ] = SERVER_EMAIL;
			$parseArr [ 'WEB_SITE' ] = LEPTON_URL;
			$parseArr [ 'WEB_FUNCTIE' ] = sprintf ('annuiteiten berekening %s ( %s )', $_POST [ 'gsm_d002' ] ?? "" ,$_POST [ 'gsm_d005' ] ?? "" );
			$parseArr [ 'WEB_TIMESTAMP' ] = date ( "Y-m-d H:i" );
 			$oFC->description .= $oFC->gsm_mail ( $template, $_POST [ 'gsm_email' ], $parseArr, 1, '', '', $attachments ); 
			$oFC->page_content [ 'MODE' ] = 9;
			break;
		default:
			$oFC->page_content [ 'MODE' ] = 9;
			break;
	} 
} elseif ( isset ( $_GET[ 'command' ] ) ) {
	switch ( $_GET[ 'command' ] ) {	
		case "remove":
			$query = sprintf ("DELETE  FROM `%s` WHERE `type` = 'ay' AND `id` = '%s' ", $oFC->file_ref [ 99 ], $_GET [ 'id' ]);
			$database->simple_query ( $query );
			/* debug */ Gsm_debug (array ( "query"=>	$query ), __LINE__ . "content" ); /* end */ 
			$oFC->page_content [ 'MODE' ] = 9;
			$oFC->page_content [ 'P1' ] = true; // eerste cycle 
			$oFC->page_content [ 'd005' ] = "P" . date('U');
			$oFC->gsm_existDir ( $oFC->page_content [ 'pdf_location' ]  , true  );
			/* checks op inhoud */ 
			$oFC->gsm_validateCheck 	( $oFC->page_content, $oFC->user, $oFC->file_ref [ 99 ] );
			/* read stored items to  select */
			if ( isset ( $oFC->page_content [ 'd001' ]) && !isset ( $_POST[ 'gsm_d011' ] ) ) {
			/* get record if any */
				$oFC->gsm_selectionRead ($oFC->page_content, $oFC->file_ref [ 99 ] );
			}
			break;
		case "select":
			$oFC->gsm_selectionSelect ( $oFC->page_content , $oFC->file_ref [ 99 ], $_GET [ 'id' ]);
			/* checks op inhoud */ 
			$oFC->gsm_validateCheck 	( $oFC->page_content, $oFC->user, $oFC->file_ref [ 99 ] );
			$oFC->page_content [ 'MODE' ] = 9;
			break;
		default:
			// escape route 
			$oFC->page_content [ 'P1' ] = true; // eerste cycle assumed
			$oFC->page_content [ 'MODE' ] = 9;
			break;
	} 
} else {
	$oFC->page_content [ 'MODE' ] = 9;
	$oFC->page_content [ 'P1' ] = true; // eerste cycle 
	$oFC->page_content [ 'd005' ] = "P" . date('U');
	$oFC->gsm_existDir ( $oFC->page_content [ 'pdf_location' ]  , true  );
	/* checks op inhoud */ 
	$oFC->gsm_validateCheck 	( $oFC->page_content, $oFC->user, $oFC->file_ref [ 99 ] );
	/* read stored items to  select */
	if ( isset ( $oFC->page_content [ 'd001' ]) && !isset ( $_POST[ 'gsm_d011' ] ) ) {
		/* get record if any */
		$oFC->gsm_selectionRead ($oFC->page_content, $oFC->file_ref [ 99 ] );
	}
}

// einde input verwerking
/* debug * / Gsm_debug (array ( "this"=>$oFC), __LINE__ . __FUNCTION__ ); /* end */

/* opmaak voor de uitvoer */
if ( !$oFC->page_content [ 'P1' ] ) {
	$check = $oFC->setting [ 'includes' ] . "v" . substr ( $module_name, 1 ) . '_check' . '1'  . '.php';
	if ( file_exists ( $check  ) ) require ( $check ); 

	/* opmaak voor de uitvoer : de filenaam */
	$oFC->setting [ 'pdf_filename' ] = $oFC->gsm_sanitizeStrings ( sprintf ( "calculation_%s_%s_%s.pdf", 
		date ( "Ymd", time ( ) ), 
		$oFC->page_content [ 'd001' ], 
		$oFC->page_content [ 'd003' ] ), "s{FILE}" );
	/*  de print */
	$oFC->gsm_print ( "", 
			$project, "" , 
			"1", 
			$oFC->page_content [ 'pdf_location' ]  );	
	/*  einde uitvoer */
}

/* the selection options */
switch ( $oFC->page_content [ 'MODE' ] ) {
	default: 
		$oFC->page_content [ 'SELECTIONA' ] = $oFC->gsm_opmaakSel ( array ( 7 ) );
		$oFC->page_content [ 'SELECTIONB' ] = $oFC->gsm_opmaakSel ( array ( 6 ) );
		if ( !$oFC->page_content [ 'P1' ] ) {
			$oFC->page_content [ 'SELECTIONX' ] = str_replace ( "---", "", $oFC->page_content [ 'pdf_location' ] . $oFC->setting [ 'pdf_filename' ]);
			$oFC->page_content [ 'SELECTIONC' ] = $oFC->gsm_opmaakSel ( array ( 11 ), 
				"-", 
				$oFC->setting [ 'pdf_filename' ], 
				"-", "-", "-", "-", 
				$oFC->page_content [ 'pdf_location' ] );
			if ( $oFC->user [  "privileged" ] >0 ) {
				$oFC->page_content [ 'SELECTIONC' ] .= '<br /><button class="ui blue basic button" name="command" value="Email" type="submit"><i class="mail icon"></i> Mail naar :</button>';
				$oFC->page_content [ 'SELECTIONC' ] .= sprintf ( '<div class="ui transparent input"><input type="text" name="gsm_email" value="%s" /> </div>', $oFC->page_content  [  "d001" ] );
			}
			/* end mail met attachment */	
		}
		$oFC->page_content [ 'SELECTIOND' ] = $oFC->gsm_opmaakSel ( array ( 6, 7 ) );
		break; 	
}

/* the output to the screen */
if ( $oFC->page_content [ 'P1' ] ) { 
	$oFC->page_content [ 'REFERENCE_ACTIVE1'] = 'active'; 
	$oFC->page_content [ 'REFERENCE_ACTIVE2'] = ''; 
	$oFC->page_content [ 'REFERENCE_ACTIVE3'] = ''; 
	$oFC->page_content [ 'REFERENCE_ACTIVE4'] = ''; 
	$oFC->page_content [ 'REFERENCE_ACTIVE5'] = '';
} else {
	$oFC->page_content  [ 'D008_ACTIVE' ] = $oFC->gsm_selectOption ( $oFC->language [ 'active' ], $oFC->page_content  [ 'd008' ] ?? 1, 1);
	$oFC->page_content [ 'REFERENCE_ACTIVE1'] = ''; 
	$oFC->page_content [ 'REFERENCE_ACTIVE2'] = 'active'; 
	$oFC->page_content [ 'REFERENCE_ACTIVE3'] = ''; 
	$oFC->page_content [ 'REFERENCE_ACTIVE4'] = ''; 
	$oFC->page_content [ 'REFERENCE_ACTIVE5'] = '';
}

/* Output processing */
/* Memory save * /
$oFC->page_content ['MEMORY'] = $oFC->gsm_memorySaved ( ); 

/* Messages to show */
$oFC->page_content[ 'STATUS_MESSAGE' ] .= $oFC->description; 
if (strlen($oFC->page_content[ 'STATUS_MESSAGE' ])>4 ) $oFC->page_content['MESSAGE_CLASS']= "ui error message"; 
$oFC->page_content[ 'VERSIE' ] = $oFC->version; 
if (LOAD_MODE == "x" )  $_SESSION[ 'last_edit_section' ] = $section_id; 

/* Actual output */
echo $oTWIG->render( 
	$template_name, // template-filename
    $oFC->page_content // template-data
);
/* End output processing */

/* debug * /  Gsm_debug ($oFC->page_content, __LINE__ . $template_name ); 
if (LOAD_MODE == "x" )  Gsm_debug ($oFC->version, $template_name ); /* end */ 
?>