<?php
/*
 *  @template       GSM_Lepton Standard
 *  @version        see info.php of this module
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this module
 *  @platform       see info.php of this module
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php
 
$this->version ['2pdf1'] = "20251022";

$prmode = array ( 1 , 2 );
if ( $this->page_content [ 'd008' ] > 1 &&  count ($this->page_content [ 'd030' ]) >2 ) { 
	$prmode = array ( 1, 2, 3, 4 ); 
}

$titel0 = explode ( "(", $title);
$titel = $titel0  [ 0 ];

/* opening printstream met css, header and footer */	
$prout  = "";
/* stylesheet */
$prout .= '<style>';
$prout .= 'h3 				{ color: #990000; font-style: italic; display: block; }
	h4 						{ color: #880088; font-style: italic; display: block; margin-bottom: 8mm; text-decoration: underline;}
	p.droplet 				{ height: 100mm; line-height: 5.25mm;   border: solid 1px #880000; width: 50%;}
	.gsm_example 			{ text-align: }
	th.gsm_example_center 	{ text-align: center; }
	.gsm_right 				{ text-align: right; }';
$prout .= '</style>';

$prout .= '<page footer="date,time" backtop="14mm" backbottom="14mm" backleft="15mm" backright="10mm" style="font-size: 12pt">';

/*header */
$prout .= '<page_header>
        <table class="page_header">
            <tr>
				<td style="width: 150mm;">
                   <h3>'. $titel .'</h3>
                </td>
                <td style="width: 50mm;">
                   <img src="[[ LEPTON_PATH ]]/modules/gsmofft/img/pdflogo.png" alt="" >
                </td>
            </tr>
        </table>
    </page_header>';
	
/* footer */	
$prout .= '<page_footer>
		<p style="text-align: right;">[[date_d]]-[[date_m]]-[[date_y]]  [[date_h]]:[[date_i]]:[[date_s]] Pagina [[page_cu]]/[[page_nb]] </p>
    </page_footer>';	
/* eind opening printstream  */

if ( isset ( $this->setting [ 'pdf_filename' ] ) && strlen ( $this->setting [ 'pdf_filename' ] ) > 10 ) {
	$printOK = true;
	$pdf_line = "";
	$pdf_text = "";
	$TEMPLATE1 = '<tr>
		<td style="width: 70mm;">%s</td>
		<td class="gsm_right" style="width: 50mm;">%s</td>
		<td style="width: 30mm;">%s</td></tr>';
	$Lhulpa = strtotime ($this->page_content [ 'd013' ]);
	$Lhulpb = strtotime ($this->page_content [ 'd019' ]);
	$dagVerschil = intval ( ( abs ( $Lhulpa - $Lhulpb ) )/86400);  // 86400 seconds in een dag
	$maandVerschil = $dagVerschil / 31;
	$correctie_rente = 0;
	if ( $maandVerschil > $this->page_content [ 'd017' ] ) {
		/* correctiebedrag */ 
		$extra_dagen = intval( $dagVerschil - (365 / 12 * $this->page_content [ 'd017' ] ) );
		$correctie_rente = $this->page_content [ 'd011' ] * $this->page_content [ 'd012' ] / 36500 * $extra_dagen;
	}
} else {
	$prmode = array ( );
}
if ( in_array ( 1, $prmode ) ) {
	$pdf_text .= '<bookmark title="Basis gegevens" level="0" ></bookmark>';
	$pdf_text .= '<h3>Basis gegevens</h3>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= sprintf ( $TEMPLATE1, "Onze ref : ", $this->page_content [ 'd005' ] , "");
	$pdf_text .= sprintf ( $TEMPLATE1, "Uw ref : ", $this->page_content [ 'd002' ] , "");
	$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'd011' ], "s{ EURO|KOMMA }"); 
	$pdf_text .= sprintf ( $TEMPLATE1, "Bedrag Lening : ", $LocalHulp , "");
	$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'd012' ], "s{ KOMMA }" ). "%";
	$pdf_text .= sprintf ( $TEMPLATE1, "Rente : ", $LocalHulp,	"");
	$LocalHulp = $this->gsm_sanitizeStrings ( date ( "d M Y", strtotime ( $this->page_content [ 'd013' ] ) ), "s{ DATUM }" );
	$pdf_text .= sprintf ( $TEMPLATE1, "Vanaf : ", $LocalHulp, "");
	$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'd015' ], "s{ KOM1 }" ). " jaar";
	$pdf_text .= sprintf ( $TEMPLATE1, "Aflossingstermijn : ", $LocalHulp, "");
	$pdf_text .= sprintf ( $TEMPLATE1, "Aflossings Schema : ", "Annuiteitsbasis", "");
	$LocalHulp = $this->gsm_sanitizeStrings ( date ( "d M Y", strtotime ( $this->page_content [ 'd019' ] ) ), "s{ DATUM }" );
	$pdf_text .= sprintf ( $TEMPLATE1, "Eerste vervaldatum : ", $LocalHulp, "");
	$pdf_text .= sprintf ( $TEMPLATE1, "Verder elk(e) : ", $this->page_content [ 'd014' ], "");	
	if ( $correctie_rente > 0 ) {
		$LocalHulp = $this->gsm_sanitizeStrings ( $correctie_rente, "s{ KOMMA|EURO }" );
		$pdf_text .= sprintf ( $TEMPLATE1, "Rente uitgestelde aflossing : ", $LocalHulp, "");
		/* correcties aflossingsbedrag */	
		$i = $this->page_content [ 'd012' ] / 100 / 12 * $this->	page_content [ 'd017' ] ;
		$i2= 1+$i;
		$n = ceil ($this->page_content [ 'd015' ] * 12  /  $this->page_content [ 'd017' ] );
		$m = -$n;
		$i3 = $i2**$m;
		$i4 = 1 - $i3;
		$this->page_content [ 'd018' ] = round ( $i * ( $this->page_content [ 'd011' ] + $correctie_rente ) / $i4 + 0.0049, 2 ) ;

		$this->page_content [ 'd016' ] = $this->gsm_sanitizeStringV ( $this->page_content [ 'd016' ] ?? $this->page_content [ 'd018' ], 
		"v{" . $this->page_content [ 'd018' ] . ";" 
			. $this->page_content [ 'd018' ]  . ";" 
			. $this->page_content [ 'd011' ]  ."}" );
	} else {
		$correctie_rente= 0;
	}
	$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'd016' ], "s{ KOMMA|EURO }" );
	$pdf_text .= sprintf ( $TEMPLATE1, "Annuiteit (rente en aflossing) : ", $LocalHulp, "" );
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = '</page>';
}			

if ( in_array ( 2, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Annuiteiten schema" level="0" ></bookmark>';
	$pdf_text .= '<h3>Annuiteiten schema (rente en aflossings afspraak)</h3>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= '<tr>
		<th class="gsm_example" style="width: 10mm;">Vlg</th>
		<th class="gsm_example" style="width: 28mm;">verval datum</th>
		<th class=gsm_example_center style="width: 25mm;">open</th>
		<th class="gsm_example" style="width: 22mm;">rente</th>
		<th class="gsm_example" style="width: 25mm;">afgelost</th>
		<th class="gsm_example" style="width: 60mm;">te betalen</th>
		</tr>';
	$regelcount = 1;
	$periode_lening = $this->page_content [ 'd011' ] + $correctie_rente;
	$rente_fractie = $this->page_content [ 'd012' ]  * $this->page_content [ 'd017' ] / 12 / 100;
	$periode_verval = strtotime ( $this->page_content [ 'd019' ] ); 
	$periode_gap = "+1 month";
	$periode_ann = $this->page_content [ 'd016' ];
	$totaal_rente = 0;
	$totaal_afgelost = 0;
	$TEMPLATE2 = '<tr><th class="gsm_example" style="width: 10mm;">%s</th>
			<td class="gsm_example" style="width: 28mm;">%s</td>
			<td class="gsm_right" style="width: 25mm;">%s</td>
			<td class="gsm_right" style="width: 22mm;">%s</td>
			<td class="gsm_right" style="width: 25mm;">%s</td>
			<td class="gsm_right" style="width: 60mm;">%s</td></tr>';
	if ( $correctie_rente > 0 ) {
		$LocalHulp1 = $this->gsm_sanitizeStrings ( $correctie_rente, "s{ EURO|KOMMA }" );
		$LocalHulp2 = $this->gsm_sanitizeStrings (  $correctie_rente * -1, "s{ EURO|KOMMA }" );
		$pdf_text .= sprintf ( $TEMPLATE2, "",	"",	"", $LocalHulp1, $LocalHulp2, "Rente uitgestelde aflossing"	);
		$totaal_rente = $totaal_rente + $correctie_rente;
		$totaal_afgelost = $totaal_afgelost - $correctie_rente;
	}
	for ($n = 1; $periode_lening > 0 && $n < 361; $n++) {
		$periode_rente = $periode_lening * $rente_fractie;
		if ( $periode_lening + $periode_rente < $periode_ann ) $periode_ann = $periode_lening + $periode_rente;
	
		$LocalHulp1 = date ( "Y-m-d", $periode_verval );
		$LocalHulp2 = $this->gsm_sanitizeStrings ( $periode_lening, "s{ EURO|KOMMA }" );
		$LocalHulp3 = $this->gsm_sanitizeStrings ( $periode_rente, "s{ EURO|KOMMA }" );
		$LocalHulp4 = $this->gsm_sanitizeStrings ( ( $periode_ann - $periode_rente ), "s{ EURO|KOMMA }" );
		$LocalHulp5 = $this->gsm_sanitizeStrings ( $periode_ann, "s{ EURO|KOMMA }" );	
		$pdf_text .= sprintf ( $TEMPLATE2, $n, $LocalHulp1, $LocalHulp2, $LocalHulp3, $LocalHulp4, $LocalHulp5);

		/* cumulatief */
		$totaal_rente = $totaal_rente + $periode_rente;
		$totaal_afgelost = $totaal_afgelost + $periode_ann - $periode_rente;
		
		/* volgende periode  */		
		$periode_verval = strtotime ( $periode_gap , $periode_verval ); 
		$periode_lening = $periode_lening + $periode_rente - $periode_ann;
	}

	$periode_rente = $periode_lening * $rente_fractie;
	if ( $periode_lening + $periode_rente < $periode_ann ) $periode_ann = $periode_lening + $periode_rente;
	$pdf_text .= sprintf ( $TEMPLATE2, "", "", "", "", "", "" );
	$LocalHulp1 = $this->gsm_sanitizeStrings ( $periode_lening, "s{ EURO|KOMMA }" );
	$LocalHulp2 = $this->gsm_sanitizeStrings ( $totaal_rente, "s{ EURO|KOMMA }" );
	$LocalHulp3 = $this->gsm_sanitizeStrings ( $totaal_afgelost, "s{ EURO|KOMMA }" );
	$pdf_text .= sprintf ( $TEMPLATE2, "**", "totalen", $LocalHulp1, $LocalHulp2, $LocalHulp3, "" );
	$regelcount++;
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = '</page>';
}

if ( in_array ( 3, $prmode ) ) {
	/* ontvangsten en betalingen */
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Financiele boekingen" level="0" ></bookmark>';
	$pdf_text .= '<h3>Financiele boekingen</h3>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= '<tr>
	<th class="gsm_example" style="width: 10mm;">Vlg</th>
	<th class="gsm_example" style="width: 28mm;">Datum</th>
	<th class=gsm_example_center style="width: 25mm;">transactie</th>
	<th class="gsm_example" style="width: 22mm;"></th>
	<th class="gsm_example" style="width: 25mm;"></th>
	<th class="gsm_example" style="width: 60mm;">opm</th>
	</tr>';
	$TEMPLATE3 = '<tr><th class="gsm_example" style="width: 10mm;">%s</th>
		<td class="gsm_example" style="width: 28mm;">%s</td>
		<td class="gsm_right" style="width: 25mm;">%s</td>
		<td class="gsm_right" style="width: 22mm;">%s</td>
		<td class="gsm_right" style="width: 25mm;">%s</td>
		<td class="gsm_right" style="width: 60mm;">%s</td></tr>';
	$n = 1;
	$lHulpA = array ();
	/* voeg toe beschikbaarstelling toe */
	$lHulpA [ $this->page_content [ 'd013' ] ] = $this->page_content [ 'd011' ]*-1;
	/* voeg toe de betalingen */
	foreach ( $this->page_content [ 'd030' ] as $pay => $load ) {
		if ( $pay <= $this->page_content [ 'DATE' ] ) $lHulpA [ $pay ]= $load; 
	}
	ksort ( $lHulpA );
	
	foreach ( $lHulpA as $pay => $load ) {
		$LocalHulp1 = ( $load < 0 ) ? sprintf ( "( %s )", $load * -1 ) : $load ;
		$LocalHulp2 = ( $this->page_content [ 'd013' ] == $pay ) ? "beschikbaarstelling" : "";
		$pdf_text .= sprintf ( $TEMPLATE3, $n,  $pay, $LocalHulp1, "", "", $LocalHulp2 );
		$n++;
	}
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = '</page>';
}
	
/*lening overzicht */
if ( in_array ( 4, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
		$pdf_text .= '<bookmark title="Lening Overzicht" level="0" ></bookmark>';
		$pdf_text .= '<h3>Lening Overzicht</h3>';
		$pdf_text .= '<table class="page_header" >';
		$pdf_text .= '<tr>
			<th class="gsm_example" style="width: 10mm;">Vlg</th>
			<th class="gsm_example" style="width: 28mm;">verval datum</th>
			<th class=gsm_example_center style="width: 25mm;">open</th>
			<th class="gsm_example" style="width: 22mm;">rente</th>
			<th class="gsm_example" style="width: 25mm;">afgelost</th>
			<th class="gsm_example" style="width: 60mm;">te betalen</th>
			</tr>';
		$periode_lening = $this->page_content [ 'd011' ] + $correctie_rente;
		$rente_fractie = $this->page_content [ 'd012' ]  * $this->page_content [ 'd017' ] / 12 / 100;
		$periode_verval = strtotime ( $this->page_content [ 'd019' ] ); 
		$periode_gap = "+1 month";
		$periode_ann = $this->page_content [ 'd016' ];
		$totaal_rente = 0;
		$totaal_afgelost = 0;
	$TEMPLATE4 = '<tr><th class="gsm_example" style="width: 10mm;">%s</th>
		<td class="gsm_example" style="width: 28mm;">%s</td>
		<td class="gsm_right" style="width: 25mm;">%s</td>
		<td class="gsm_right" style="width: 22mm;">%s</td>
		<td class="gsm_right" style="width: 25mm;">%s</td>
		<td class="gsm_right" style="width: 60mm;">%s</td></tr>';
	$n = 1;
	$lHulpA = array ();
	/* voeg toe de betalingen */
	foreach ( $this->page_content [ 'd030' ] as $pay => $load ) {
		if ( $pay <= $this->page_content [ 'DATE' ] ) $lHulpA [ $pay ] = $load; 
	}
	ksort ( $lHulpA );
	$n=0;
	$this->page_content [ 'afrekenen' ] = true;
	$betaalperiode_begin = $this->page_content [ 'd013' ];
	$betaalperiode_eind = $this->page_content [ 'd019' ];
	$periode_lening = $this->page_content [ 'd011' ] + $correctie_rente;
	$rente_fractie = $this->page_content [ 'd012' ]  * $this->page_content [ 'd017' ] / 12 / 100;
	$periode_verval = strtotime ( $this->page_content [ 'd019' ] ); 
	$periode_gap = $periode_gap = sprintf ("+%s month" , $this->page_content [ 'd017' ] );
	$periode_ann = $this->page_content [ 'd016' ];
	$totaal_rente = 0;
	$totaal_afgelost = 0;
	$eerste_periode_na_vandaag_komt_nog = true; 

	/* beschikbaarstelling */
	$periode_lening = $this->page_content [ 'd011' ];
	$pdf_text .= sprintf ( $TEMPLATE4, "", "", "", "", "", "" );
	$LocalHulp1 = $this->gsm_sanitizeStrings ( $periode_lening, "s{ EURO| KOMMA }" );
	$pdf_text .= sprintf ( $TEMPLATE4, "", 
		$this->page_content [ 'd013' ], 
		$LocalHulp1, "", "", 
		"beschikbaarstelling" );
	$n++;

	/* rente uitgestelde aflossing */
	$periode_lening =  $periode_lening + $correctie_rente;
	if ( $correctie_rente > 0 ) {
		$LocalHulp1 = $this->gsm_sanitizeStrings ( $periode_lening, "s{ EURO| KOMMA }" );
		$LocalHulp2 = $this->gsm_sanitizeStrings ( $correctie_rente, "s{ EURO| KOMMA }" );
		$pdf_text .= sprintf ( $TEMPLATE4, "", "", 
			$LocalHulp1, 
			$LocalHulp2, "", 
			"rente uitgestelde aflossing" );
		$totaal_rente = $totaal_rente + $correctie_rente;
		$totaal_afgelost = $totaal_afgelost - $correctie_rente;
		$n++;
	}
	for ($n = 1; $periode_lening > 0 && $n < 361; $n++) {
		/* zoek betaling */
		if ($this->page_content [ 'afrekenen']) {
			/* zoek betaling */
			$periode_afgerekend = 0;
			foreach ( $lHulpA  as $pay => $load ) {
				if ( $pay <= $this->page_content [ 'DATE' ] && $pay > $betaalperiode_begin && $betaalperiode_eind >= $pay ) {
					$periode_afgerekend = $periode_afgerekend + $load;
					$LocalHulp1 = $this->gsm_sanitizeStrings ( $load, "s{ EURO|KOMMA }" );
					$pdf_text .= sprintf ( $TEMPLATE4, "",
						$pay, "",
						$LocalHulp1, "", 
						"rente en aflossing" );
				}
			}
		}
		$periode_rente = $periode_lening * $rente_fractie;
		if ($this->page_content [ 'afrekenen']) { 
			if  ($eerste_periode_na_vandaag_komt_nog) {
				if (date ( "Y-m-d", $periode_verval )> $this->page_content [ 'DATE' ]){
					$eerste_periode_na_vandaag_komt_nog= false;
					$pdf_text .= sprintf ( $TEMPLATE4, "",
						$this->page_content [ 'DATE' ], "", "", "", "" );
				}
			}
			
			/* laatste termijn */
			if ( $periode_lening + $periode_rente < $periode_ann ) 
				$periode_ann = $periode_lening + $periode_rente;
			$LocalHulp1 = date ( "Y-m-d", $periode_verval );
			$LocalHulp2 = $this->gsm_sanitizeStrings ( $periode_lening, "s{ EURO|KOMMA }" );
			$LocalHulp3 = $this->gsm_sanitizeStrings ( $periode_rente, "s{ EURO|KOMMA }" );
			$LocalHulp4 = ( date ( "Y-m-d", $periode_verval ) > $this->page_content [ 'DATE' ]  
				&& $periode_afgerekend == 0 )
				? $this->gsm_sanitizeStrings ( ( $periode_ann - $periode_rente ), "s{ EURO|KOMMA }" )
				: $this->gsm_sanitizeStrings ( ( $periode_afgerekend - $periode_rente ), "s{ EURO|KOMMA }" );
			$LocalHulp5 = ( date ( "Y-m-d", $periode_verval ) > $this->page_content [ 'DATE' ] 
				&& $periode_afgerekend == 0 ) 
				? $this->gsm_sanitizeStrings ( $periode_ann, "s{ KOMMA }" ) 
				: "verrekening : " . $this->gsm_sanitizeStrings ( $periode_afgerekend, "s{ EURO|KOMMA }" );						
			$pdf_text .= sprintf ( $TEMPLATE4, $n,
				$LocalHulp1, 
				$LocalHulp2, 
				$LocalHulp3, 
				$LocalHulp4, 
				$LocalHulp5 );
			/* cumulatief */
			$totaal_rente = $totaal_rente + $periode_rente;
			$totaal_afgelost = ( date ( "Y-m-d", $periode_verval ) > $this->page_content [ 'DATE' ]   
				&& $periode_afgerekend == 0 )
				? $totaal_afgelost + $periode_ann - $periode_rente
				: $totaal_afgelost + $periode_afgerekend - $periode_rente;
	
			/* volgende periode */
			$periode_verval = strtotime ( $periode_gap , $periode_verval ); 
			$betaalperiode_begin = $betaalperiode_eind;
			$betaalperiode_eind = date ( "Y-m-d", $periode_verval );
			$periode_lening = ( date ( "Y-m-d", $periode_verval ) > $this->page_content [ 'DATE' ] 
				&& $periode_afgerekend == 0 )
				? $periode_lening + $periode_rente - $periode_ann 
				: $periode_lening + $periode_rente - $periode_afgerekend;	
		}
	}
	$periode_rente = $periode_lening * $rente_fractie;
	if ( $periode_lening + $periode_rente < $periode_ann ) $periode_ann = $periode_lening + $periode_rente;
	$pdf_text .= sprintf ( $TEMPLATE4, "", "", "", "", "", "" );
	$LocalHulp1 = $this->gsm_sanitizeStrings ( $periode_lening, "s{ EURO|KOMMA }" );
	$LocalHulp2 = $this->gsm_sanitizeStrings ( $totaal_rente, "s{ EURO|KOMMA }" );
	$LocalHulp3 = $this->gsm_sanitizeStrings ( $totaal_afgelost, "s{ EURO|KOMMA }" );
	$pdf_text .= sprintf ( $TEMPLATE4, 
		"**",
		"totalen" ,
		$LocalHulp1, 
		$LocalHulp2, 
		$LocalHulp3, 
		"" );
	$regelcount++;
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = '</page>';
}

if ( in_array ( 1, $prmode ) ) { 
	$prout .= $pdf_text;
	$oPDF = lib_html2pdf::getInstance();
	$oPDF->setAuthor( "ContractHulp");
	$oPDF->setCreator( $this->setting [ 'droplet'] [ 'NL1'] );
	$oPDF->setTitle( $title );
	$oPDF->setSubject( $query );
	$oPDF->setKeywords ( $query );

	$oPDF->writeHTML( $prout );
	$oPDF->output($pdflink, 'F');
}
?>