<?php
/*
 *  @template       GSM_Lepton 7 Standard
 *  @version        see info.php of this template
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this template
 *  @license terms  see info.php of this template
 *  @platform       see info.php of this template
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php

/* bepaling vervaldatum correctie nodig en correctiebedrag*/
$Lhulpa = strtotime ($oFC->page_content [ 'd013' ]);
$Lhulpb = strtotime ($oFC->page_content [ 'd019' ]);
$dagVerschil = intval ( ( abs ( $Lhulpa - $Lhulpb ) )/86400);  // 86400 seconds in een dag
$maandVerschil = $dagVerschil / 31;
$correctie_rente = 0;
if ( $maandVerschil > $oFC->page_content [ 'd017' ] ) {
	/* correctiebedrag */ 
	$extra_dagen = intval( $dagVerschil - (365 / 12 * $oFC->page_content [ 'd017' ] ) );
	$correctie_rente = $oFC->page_content [ 'd011' ] * $oFC->page_content [ 'd012' ] / 36500 * $extra_dagen;
	/*debug * / Gsm_debug ( array ( $maandVerschil, $oFC->page_content [ 'd017' ], $extra_dagen, $correctie_rente), __LINE__ . __FUNCTION__ ); /* end */
}
/*debug * / Gsm_debug ( array ( $oFC->page_content ), __LINE__ . __FUNCTION__ ); /* end */
$TEMP0 = '<hr /><table>';
$TEMP1= '<tr><td colspan="7">%s</td></tr>';
$TEMP2= '<tr><td colspan="7"><h3>%s: %s </h3></td></tr>';
$TEMP3=	'<tr><td colspan="2">%s : </td><td colspan="5">%s</td></tr>';
$TEMP4=	'<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>';
$TEMP5=	'<tr><td colspan="2">%s : </td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>';
$TEMP9 = '</table>';
$oFC->page_content [ 'RAPPORTAGE' ] .= $TEMP0;
/* Titel */
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ($TEMP2,
	"Lening Overzicht",
	$oFC->page_content [ 'd002' ]);
/* Details lening */
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3, 
	"Datum berekening",
	$oFC->gsm_sanitizeStrings ( date ( "d M Y", time ( ) ), "s{ DATUM }" ));
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP1, "<hr />");
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP1, "Lening");
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3,
	"Bedrag lening",
	$oFC->gsm_sanitizeStrings ( $oFC->page_content [ 'd011' ], "s{ KOMMA|EURO }" ));
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3, 
	"Vanaf",
	$oFC->gsm_sanitizeStrings ( date ( "d M Y", strtotime ( $oFC->page_content [ 'd013' ] ) ), "s{ DATUM }" ) );
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3, 
	"Aflossingstermijn",
	"ca. ". $oFC->gsm_sanitizeStrings ( $oFC->page_content [ 'd015' ], "s{ KOM1 }" ). " jaar");
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3, 
	"Rente",
	$oFC->gsm_sanitizeStrings ( $oFC->page_content [ 'd012' ], "s{ KOMMA }" ). "%");
	
if ( $oFC->user [ 'privileged' ] > 1 ) {
	$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP1, 
		$oFC->page_content [ 'd009' ]);	
}
	
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP1, "<hr />");
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP1, "Aflossingsschema ( annuiteitenbasis )");
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3, 
	"Eerste vevaldag",
	$oFC->gsm_sanitizeStrings ( date ( "d M Y", strtotime ( $oFC->page_content [ 'd019' ] ) ), "s{ DATUM }" ) );
	
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3, 
	"Verder elk(e) ",
	$oFC->page_content [ 'd014' ] );
if ( $correctie_rente > 0 ) {$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3, 
	"Rente uitgestelde aflossing",
	$oFC->gsm_sanitizeStrings ( $correctie_rente, "s{ KOMMA|EURO }" ));	
	
	/* correcties aflossingsbedrag */	
	$i = $oFC->page_content [ 'd012' ] / 100 / 12 * $oFC->page_content [ 'd017' ] ;
	$i2= 1+$i;
	$n = ceil ($oFC->page_content [ 'd015' ] * 12  /  $oFC->page_content [ 'd017' ] );
	$m = -$n;
	$i3 = $i2**$m;
	$i4 = 1 - $i3;
	$oFC->page_content [ 'd018' ] = round ( $i * ( $oFC->page_content [ 'd011' ] + $correctie_rente ) / $i4 + 0.0049, 2 ) ;

	$oFC->page_content [ 'd016' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'd016' ] ?? $oFC->page_content [ 'd018' ], 
	"v{" . $oFC->page_content [ 'd018' ] . ";" 
		. $oFC->page_content [ 'd018' ]  . ";" 
		. $oFC->page_content [ 'd011' ]  ."}" );
} else {
	$correctie_rente= 0;
}
$oFC->page_content [ 'afrekenen'] = false;
$betaalperiode_begin = $oFC->page_content [ 'd013' ];
$betaalperiode_eind = $oFC->page_content [ 'd019' ];
if ( count ($oFC->page_content [ 'd030' ] ) >1 )  $oFC->page_content [ 'afrekenen'] = true;
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP3, 
	"Annuiteit (rente en aflossing)",
	$oFC->gsm_sanitizeStrings ( $oFC->page_content [ 'd016' ], "s{ KOMMA|EURO }" ));	
$oFC->page_content [ 'RAPPORTAGE' ] .= $TEMP9;
$oFC->page_content [ 'RAPPORTAGE' ] .= $TEMP0;
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP4, 
	"vlg",
	"verval datum",
	"open",
	"(te) betalen",
	"rente",
	"aflossing",
	"opm" );
/* schema */
$n=0;
$periode_lening = $oFC->page_content [ 'd011' ] + $correctie_rente;
$rente_fractie = $oFC->page_content [ 'd012' ]  * $oFC->page_content [ 'd017' ] / 12 / 100;
$periode_verval = strtotime ( $oFC->page_content [ 'd019' ] ); 
$periode_gap = sprintf ("+%s month" , $oFC->page_content [ 'd017' ] );
$periode_ann = $oFC->page_content [ 'd016' ];
$totaal_rente = 0;
$totaal_afgelost = 0;
$eerste_periode_na_vandaag_komt_nog = true; 

if ( $correctie_rente > 0 ) {
	$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP4, 
		"",
		"",
		"",
		"",
		$oFC->gsm_sanitizeStrings ( $correctie_rente, "s{ KOMMA }" ),
		$oFC->gsm_sanitizeStrings ( $correctie_rente * -1, "s{ KOMMA }" ),
		"Rente uitgestelde aflossing" );
	$totaal_rente = $totaal_rente + $correctie_rente;
	$totaal_afgelost = $totaal_afgelost - $correctie_rente;
}

for ($n = 1; $periode_lening > 0 && $n < 361; $n++) {
	/* zoek betaling */
	if ($oFC->page_content [ 'afrekenen']) {
		/* zoek betaling */
		$periode_afgerekend = 0;
		foreach ( $oFC->page_content [ 'd030' ]  as $pay => $load ) {
			if ( $pay <= $oFC->page_content [ 'DATE' ] && $pay > $betaalperiode_begin && $betaalperiode_eind >= $pay ) {
				$periode_afgerekend = $periode_afgerekend + $load;
				$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP4, 
					"",
					$pay,
					"",
					"",
					"",
					"",
					sprintf ("Ontvangen %s", $oFC->gsm_sanitizeStrings ( $load, "s{ EURO|KOMMA }" ) ) );
			}
		}
	}
	$periode_rente = $periode_lening * $rente_fractie;
	
	if ($oFC->page_content [ 'afrekenen']) { 
		if  ($eerste_periode_na_vandaag_komt_nog) {
			if (date ( "Y-m-d", $periode_verval )> $oFC->page_content [ 'DATE' ]){
				$eerste_periode_na_vandaag_komt_nog= false;
				$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP1, "<hr />");
			}
		}
		/* laatste termijn */
		if ( $periode_lening + $periode_rente < $periode_ann ) $periode_ann = $periode_lening + $periode_rente;
		
		$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP4, 
			$n,
			date ( "Y-m-d", $periode_verval ),
			$oFC->gsm_sanitizeStrings ( $periode_lening, "s{ EURO|KOMMA }" ),
			( date ( "Y-m-d", $periode_verval ) > $oFC->page_content [ 'DATE' ] 
				&& $periode_afgerekend == 0 ) 
				? $oFC->gsm_sanitizeStrings ( $periode_ann, "s{ KOMMA }" ) 
				: $oFC->gsm_sanitizeStrings ( $periode_afgerekend, "s{ KOMMA }" ),
			$oFC->gsm_sanitizeStrings ( $periode_rente, "s{ KOMMA }" ),
			( date ( "Y-m-d", $periode_verval ) > $oFC->page_content [ 'DATE' ]  
				&& $periode_afgerekend == 0 )
				? $oFC->gsm_sanitizeStrings ( ( $periode_ann - $periode_rente ), "s{ KOMMA }" )
				: $oFC->gsm_sanitizeStrings ( ( $periode_afgerekend - $periode_rente ), "s{ KOMMA }" ),
			"");	
				
		/* cumulatief */
		$totaal_rente = $totaal_rente + $periode_rente;
		$totaal_afgelost = ( date ( "Y-m-d", $periode_verval ) > $oFC->page_content [ 'DATE' ]   
				&& $periode_afgerekend == 0 )
			? $totaal_afgelost + $periode_ann - $periode_rente
			: $totaal_afgelost + $periode_afgerekend - $periode_rente;
		
		/* volgende periode */
		$periode_verval = strtotime ( $periode_gap , $periode_verval ); 
		$betaalperiode_begin = $betaalperiode_eind;
		$betaalperiode_eind = date ( "Y-m-d", $periode_verval );	
		$periode_lening = ( date ( "Y-m-d", $periode_verval ) > $oFC->page_content [ 'DATE' ] && $periode_afgerekend == 0 )
			? $periode_lening + $periode_rente - $periode_ann 
			: $periode_lening + $periode_rente - $periode_afgerekend;
	} else {
		if ( $periode_lening + $periode_rente < $periode_ann ) $periode_ann = $periode_lening + $periode_rente;
		$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP4, 
			$n,
			date ( "Y-m-d", $periode_verval ),
			$oFC->gsm_sanitizeStrings ( $periode_lening, "s{ EURO|KOMMA }" ),
			$oFC->gsm_sanitizeStrings ( $periode_ann, "s{ KOMMA }" ),
			$oFC->gsm_sanitizeStrings ( $periode_rente, "s{ KOMMA }" ),
			$oFC->gsm_sanitizeStrings ( ( $periode_ann - $periode_rente ), "s{ KOMMA }" ),
			"" );
	
		/* cumulatief */
		$totaal_rente = $totaal_rente + $periode_rente;
		$totaal_afgelost = $totaal_afgelost + $periode_ann - $periode_rente;
		
		/* volgende periode */		
		$periode_verval = strtotime ( $periode_gap , $periode_verval ); 
		$periode_lening = $periode_lening + $periode_rente - $periode_ann;
	}
}
$periode_rente = $periode_lening * $rente_fractie;
if ( $periode_lening + $periode_rente < $periode_ann ) $periode_ann = $periode_lening + $periode_rente;
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP1, "<hr />");
$oFC->page_content [ 'RAPPORTAGE' ] .= sprintf ( $TEMP5, 
		"totalen",
		$oFC->gsm_sanitizeStrings ( $periode_lening, "s{ EURO|KOMMA }" ),
		$oFC->gsm_sanitizeStrings ( $periode_ann, "s{ EURO|KOMMA }" ) ,
		$oFC->gsm_sanitizeStrings ( $totaal_rente, "s{ EURO|KOMMA }" ),
		$oFC->gsm_sanitizeStrings ( $totaal_afgelost, "s{ EURO|KOMMA }" ),
		"" );
$oFC->page_content [ 'RAPPORTAGE' ] .= '<tr><td colspan="6">  </td></tr>';
$oFC->page_content [ 'RAPPORTAGE' ] .= '</table>';
?>