<?php
/*
 *  @template       GSM_Lepton Standard
 *  @version        see info.php of this module
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this module
 *  @platform       see info.php of this module
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php
 
$this->version ['2pdf1'] = "20251022";

$prmode = array ( 1, 2 );  // ingevoerde gegevens
$prmode [] = 2;  // basis berekeningen
if ( $this->page_content [ 'a007' ] )	$prmode []= 3; // Middel
if ( $this->page_content [ 'a006' ] )	$prmode []= 4; // buikvet
if  (isset ( $this->page_content [ 'a060' ] ) ) $prmode []= 5; // knijpkracht
if ( $this->page_content [ 'a008' ] ) 	$prmode []= 6; // calorieverbruik
/* debug * / $prmode []= 9; 

/* debug * / Gsm_debug ( array ( $this->setting ), __LINE__ . __FUNCTION__ ); /* debug */ 
/* debug * / Gsm_debug ( array ( $this->page_content ), __LINE__ . __FUNCTION__ ); /* debug */ 

$titel0 = explode ( "(", $title);
$titel = $titel0  [ 0 ];

/* opening printstream met css, header and footer */	
$pdf_text= "";
$prout  = "";
/* stylesheet */
$prout .= '<style>';
$prout .= 'h3 				{ color: #990000; font-style: italic; display: block; }
	h4 						{ color: #880088; font-style: italic; display: block; margin-bottom: 8mm; text-decoration: underline;}
	p.droplet 				{ height: 100mm; line-height: 5.25mm;   border: solid 1px #880000; width: 50%;}
	.gsm_example 			{ text-align: }
	th.gsm_example_center 	{ text-align: center; }
	.gsm_right 				{ text-align: right; }';
	
$prout .= '</style>';

$prout .= '<page footer="date,time" backtop="14mm" backbottom="14mm" backleft="15mm" backright="10mm" style="font-size: 12pt">';

/*header */
$prout .= '<page_header>
        <table class="page_header">
            <tr>
				<td style="width: 150mm;">
                   <h3>'. $titel .'</h3>
                </td>
                <td style="width: 50mm;">
                   <img src="[[ LEPTON_PATH ]]/modules/gsmofft/img/pdflogo.png" alt="" >
                </td>
            </tr>
        </table>
    </page_header>';
	
/* footer */	
$prout .= '<page_footer>
		<p style="text-align: right;">[[date_d]]-[[date_m]]-[[date_y]]  [[date_h]]:[[date_i]]:[[date_s]] Pagina [[page_cu]]/[[page_nb]] </p>
    </page_footer>';	
/* eind opening printstream  */

if ( isset ( $this->setting [ 'pdf_filename' ] ) && strlen ( $this->setting [ 'pdf_filename' ] ) > 10 ) {
	$printOK = true;
	$pdf_line = "";
	$pdf_text = "";
	$TEMPLATE1 = '<tr>
		<td style="width: 60mm;">%s</td>
		<td class="gsm_right" style="width: 60mm;">%s</td>
		<td style="width: 30mm;">%s</td></tr>';
	$TEMPLATE2 = '<tr>
		<td style="width: 70mm;">%s</td>
		<td class="gsm_right" style="width: 50mm;">%s</td>
		<td style="width: 30mm;">%s</td></tr>';
	$TEMPLATE3 = '<tr>
		<td style="width: 80mm;">%s</td>
		<td class="gsm_right" style="width: 40mm;">%s</td>
		<td style="width: 30mm;">%s</td></tr>';
		
} else {
	$prmode = array ( );
}

if ( in_array ( 1, $prmode ) ) {
	$pdf_text .= '<bookmark title="Ingevoerde gegevens" level="0" ></bookmark>';
	$pdf_text .= '<h3>Ingevoerde gegevens</h3>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= sprintf ( $TEMPLATE1, "Naam : ", $this->page_content [ 'a001' ] , "");

	if ( $this->page_content [ 'a002' ] != $this->setting [ 'antropo' ][ 'z002' ] )	{
		$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'a002' ], "s{ DATUM }" ) ;
		$pdf_text .= sprintf ( $TEMPLATE1, "Geboortedatum : ", $LocalHulp , "");
	}
	$pdf_text .= sprintf ( $TEMPLATE1, "Geslacht : ", $this->page_content [ 'a009' ] , "");
	
	$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a020' ] , "s{ KOM1 }" ) . " kg"; 
	$pdf_text .= sprintf ( $TEMPLATE1, "Gewicht : ", $LocalHulp , "");
	
	$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a021' ] , "s{ KOM1 }" ) . " cm";
	$pdf_text .= sprintf ( $TEMPLATE1, "Lengte : ", $LocalHulp , "");
	
	if ( $this->page_content [ 'a023' ] > 10 ) {
		$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a023' ] , "s{ KOM1 }" ) . " cm";
		$pdf_text .= sprintf ( $TEMPLATE1, "Nek Wijdte : ", $LocalHulp , "");
	}
	
	if ( $this->page_content [ 'a022' ] > 10 ) {
		$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a022' ] , "s{ KOM1 }" ) . " cm";
		$pdf_text .= sprintf ( $TEMPLATE1, "Buikomvang : ", $LocalHulp , "");
	}
	
	if ( $this->page_content [ 'a024' ] > 10 ) {
		$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a024' ] , "s{ KOM1 }" ) . " cm";
		$pdf_text .= sprintf ( $TEMPLATE1, "Heup wijdte : ", $LocalHulp , "");
	}

	if ( $this->page_content [ 'a026' ] > 1 ) {
		$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a026' ] , "s{ KOM1 }" ) . " kg";
		$pdf_text .= sprintf ( $TEMPLATE1, "Handknijpkracht LINKS : ", $LocalHulp , "");
	}
	
	if ( $this->page_content [ 'a027' ] > 1 ) {
		$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a027' ] , "s{ KOM1 }" ) . " kg";
		$pdf_text .= sprintf ( $TEMPLATE1, "Handknijpkracht RECHTS : ", $LocalHulp , "");
	}
	
	$LocalHulp = $this->setting [ 'beweging' ] [ $this->page_content [ 'a025' ] ] ;
	$pdf_text .= sprintf ( $TEMPLATE1, "Activiteit level : ", $LocalHulp , "");

	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 2, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Analyses" level="0" ></bookmark>';
	$pdf_text .= '<h3>Analyses</h3>';
	$pdf_text .= '<bookmark title="Leeftijd" level="1" ></bookmark>';
	$pdf_text .= '<table class="page_header" >';

	$pdf_text .= sprintf ( $TEMPLATE2, "", "" , "");
	$pdf_text .= sprintf ( $TEMPLATE2, "<em>Berekening</em>", "", "");
	
	$LocalHulp = $this->page_content [ 'a030' ] . " jaar";
	$pdf_text .= sprintf ( $TEMPLATE2, "Leeftijd : ", $LocalHulp , "");
	if ( $this->page_content [ 'a002' ] == $this->setting [ 'antropo' ][ 'z002' ] 
		|| $this->page_content [ 'a030' ] < 20 ) {
		$prmode = array ( 1 );
		$pdf_text .= sprintf ( $TEMPLATE2, "", "" , "Buiten reken grenzen");
	}
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 2, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Gewicht" level="1" ></bookmark>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= sprintf ( $TEMPLATE2, "", "" , "");
	$pdf_text .= sprintf ( $TEMPLATE2, "<em>Gewichts analyse</em>", "", "");
	
	$LocalHulp1 = $this->gsm_sanitizeStrings (  $this->page_content [ 'a031' ] , "s{ KOM1 }" );
	$LocalHulp2 = $this->page_content [ 'a032' ];
	$pdf_text .= sprintf ( $TEMPLATE2, "BMI (Body Mass Index) : ", $LocalHulp1 , $LocalHulp2);

	$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a033' ] , "s{ WHOLE }" ) . 
		" - " . $this->gsm_sanitizeStrings (  $this->page_content [ 'a034' ] , "s{ WHOLE }" ) ;
	$pdf_text .= sprintf ( $TEMPLATE2, "Bij de lengte past een gewicht van :  ", $LocalHulp , "");

	if ( $this->page_content [ 'a035' ] > 1 ) {
		$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'a035' ] , "s{ WHOLE }" ).' kg';
		$pdf_text .= sprintf ( $TEMPLATE2, "Er zou dus bij mogen :  ", $LocalHulp , "");
	}
	
	if ( $this->page_content [ 'a035' ] < - 1 ) {
		$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a035' ] * -1 , "s{ WHOLE }" ).' kg';
		$pdf_text .= sprintf ( $TEMPLATE2, "Er zou dus af mogen :  ", $LocalHulp , "");
	}
	
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';	
}	

if ( in_array ( 3, $prmode ) ) {
	
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Buikomvang" level="1" ></bookmark>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= sprintf ( $TEMPLATE2, "", "" , "");	
	$pdf_text .= sprintf ( $TEMPLATE2, "<em>Buikomvang analyse</em>", "", "");
	
	$LocalHulp1 = $this->gsm_sanitizeStrings (  $this->page_content [ 'a022' ] , "s{ KOM1 }" )  . " cm";
	$LocalHulp2 = $this->page_content [ 'a038' ];
	$pdf_text .= sprintf ( $TEMPLATE2, "Buikomvang : ", $LocalHulp1 , $LocalHulp2);
	
	if 	( $this->page_content [ 'a047' ] != "" ) {
		$LocalHulp = $this->page_content [ 'a047' ] . " cm" ;
		$pdf_text .= sprintf ( $TEMPLATE2, "Bij u past een buikomvang van : ", $LocalHulp , "");
	}
	
	if 	($this->page_content [ 'a048' ] != 1 ) {
		$LocalHulp1 = $this->gsm_sanitizeStrings (  $this->page_content [ 'a048' ] , "s{ KOMMA }" );
		$LocalHulp2 = $this->page_content [ 'a049' ];
		$pdf_text .= sprintf ( $TEMPLATE2, "MHR (Middel-Heup Ratio) : ", $LocalHulp1 , $LocalHulp2);
	}

	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';	
	
}	else {
	
	if ( !in_array ( 4, $prmode ) ) {
		if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
		$pdf_text .= '<bookmark title="Lichaamsvet" level="1" ></bookmark>';
		$pdf_text .= '<table class="page_header" >';
		$pdf_text .= sprintf ( $TEMPLATE2, "", "" , "");
		$pdf_text .= sprintf ( $TEMPLATE2, "<em>Lichaamsvet analyse</em>", "", "");
		
		$LocalHulp1 = $this->gsm_sanitizeStrings (  $this->page_content [ 'a040' ] , "s{ WHOLE }" ) . " %";
		$LocalHulp2 = $this->page_content [ 'a042' ];
		$pdf_text .= sprintf ( $TEMPLATE2, "Vet percentage : ", $LocalHulp1 , $LocalHulp2);
		
		$prout .= $pdf_text;
		$prout .= '</table>';
		$pdf_text = ""; // $pdf_text = '</page>';
	}
}

if ( in_array ( 4, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Lichaamsvet" level="1" ></bookmark>';
	$pdf_text .= '<table class="page_header" >';

	$pdf_text .= sprintf ( $TEMPLATE2, "<em>Lichaamsvet analyse</em>", "", "");
	if ( $this->page_content [ 'a041' ] > $this->page_content [ 'a040' ] ) {
		$LocalHulp1 = $this->gsm_sanitizeStrings (  $this->page_content [ 'a040' ] , "s{ WHOLE }" ) . 
			" - " . $this->gsm_sanitizeStrings (  $this->page_content [ 'a041' ] , "s{ WHOLE }" ). " %";
		$LocalHulp2 = $this->page_content [ 'a042' ];
		$pdf_text .= sprintf ( $TEMPLATE2, "Vet percentage : ", $LocalHulp1 , $LocalHulp2);
	} else {
		$LocalHulp1 = $this->gsm_sanitizeStrings (  $this->page_content [ 'a041' ] , "s{ WHOLE }" ) . 
			" - " . $this->gsm_sanitizeStrings (  $this->page_content [ 'a040' ] , "s{ WHOLE }" ). " %";
		$LocalHulp2 = $this->page_content [ 'a042' ];
		$pdf_text .= sprintf ( $TEMPLATE2, "Vet percentage : ", $LocalHulp1 , $LocalHulp2);
	}
	if 	( $this->page_content [ 'a043' ] != "" ) {
		$LocalHulp = $this->page_content [ 'a043' ] . " %";
		$pdf_text .= sprintf ( $TEMPLATE2, "Bij u past een vet percentage van : ", $LocalHulp , "");
	}

	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';	
}
		
if ( in_array ( 5, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Spierkracht " level="1" ></bookmark>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= sprintf ( $TEMPLATE2, "", "" , "");
	$pdf_text .= sprintf ( $TEMPLATE2, "<em>Spierkracht analyse</em>", "", "");
		
	$LocalHulp = $this->page_content [ 'a060' ];
	$pdf_text .= sprintf ( $TEMPLATE2, "Dominantie : ", $LocalHulp , "" );

	$LocalHulp1 = $this->gsm_sanitizeStrings ( $this->page_content [ 'a061' ]  , "s{ KOMMA }" ) . ' kg' ;
	$LocalHulp2 = $this->page_content [ 'a063' ];
	$pdf_text .= sprintf ( $TEMPLATE2, "Handknijpkracht : ", $LocalHulp1 , $LocalHulp2 );

	if ( $this->page_content [ 'a061' ] < $this->page_content [ 'a062' ]) {
		$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'a062' ]  , "s{ WHOLE }" ) . ' kg';
		$pdf_text .= sprintf ( $TEMPLATE2, "Bij u past een handknijpkracht van minstens : ", $LocalHulp , "");
	}
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 6, $prmode ) ) {
	
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Caloriegebruik" level="1" ></bookmark>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= sprintf ( $TEMPLATE3, "", "" , "");
	$pdf_text .= sprintf ( $TEMPLATE3, "<em>Calorie gebruik berekening</em>", "", "");

	$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a050' ] , "s{ WHOLE }" ) . " kcal";

	$pdf_text .= sprintf ( $TEMPLATE3, "BMR (Calorie verbruik in complete rust) :  ", $LocalHulp , "");

	$LocalHulp = $this->gsm_sanitizeStrings (  $this->page_content [ 'a051' ] , "s{ WHOLE }" ) . " kcal";
	$pdf_text .= sprintf ( $TEMPLATE3, "Calorie behoefte bij activiteiten level : ", $LocalHulp , "");

	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 1, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Verantwoording" level="0" ></bookmark>';
	$LocalHulp = "Dit antropometrie overzicht is "; 
	if ( LOAD_OLINE ) {
		$LocalHulp .= sprintf ( "on-line via %s" , LEPTON_URL );
	} else {
		$LocalHulp .= "off-line";
	}
	$LocalHulp .= " gemaakt op : " . $this->gsm_sanitizeStrings ( date ( "d M Y", time ( ) ), "s{ DATUM }" ). "." ; 

	$LocalHulp .= "<br/>" . "De berekeningen en uitspraken, gedaan op basis van de ingevoerde gegevens en verwerkt volgens de gangbare normen en algoritmes, zijn met zorgvuldigheid gedaan. ";
	$LocalHulp .= "<br/>" . $this->setting [ 'droplet' ] [ 'NL2' ] . " aanvaardt geen enkele aansprakelijkheid naar aanleiding van deze berekening en de uitspraken." ; 
	$LocalHulp .= "<br/>" . "Heeft u vragen of opmerkingen, neem dan gerust contact op : "; 
	$LocalHulp .= "<br/>" . $this->setting [ 'droplet' ] [ 'NL2' ] . "<br/>" . " Web: ". $this->setting [ 'droplet' ] [ 'NL1' ]; 
	$pdf_text .= "<h5>" . $LocalHulp . "</h5>";

	$prout .= $pdf_text;
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 9, $prmode ) ) {
	if ($pdf_text != '</page>' ) $pdf_text = '</page>';
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Rekenregels" level="0" ></bookmark>';
	$prout .= $pdf_text; 
	$pdf_text= "";
	
	$LocalHulp = "De gebruikte berekenings methodes en grenswaardes.". "<br/>";
	$LocalHulp .= "<br/>" . "Berekenings methode leeftijd : Een standaard berekenings methode op basis van geboortedatum en datum tijd stempel. Als de leeftijd beneden de 20 is wordt --buiten (tabel) bereik-- genoteerd. Voor kinderen zijn de gebrukte conclusies op basis van de tabellen te vaak niet passend.";
	$pdf_text .= $LocalHulp; $LocalHulp = "";
	$LocalHulp .= "<br/><br/>" . "Berekenings methode BMI :<br/>De standaard berekenings methode op basis van kwadraat van de lengte in meters en het gewicht in kg waarbij de BMI de ratio is";
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes BMI : tot 70 jaar";
	foreach ( $this->setting [ 'BMI' ] as $key => $value ) 
		$LocalHulp .= "<br/>" .sprintf ( "- tot BMI %s : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes BMI : vanaf 70 jaar";
	foreach ( $this->setting [ 'BMI70' ] as $key => $value ) 
		$LocalHulp .= "<br/>" .sprintf ( "- tot BMI %s : %s", $key, $value ) ;
	$pdf_text .= $LocalHulp; $LocalHulp = "";
	$LocalHulp .= "<br/><br/>" . "Berekenings methode gewichtsrange : <br/>Op basis van de als normaal aangegeven BMI boven en ondergrens wordt het gewicht terug gerekend";
	$LocalHulp .= "<br/>" . "Signalering wat er bij of eraf zou moeten: het actuele gewicht wordt geplaatst in de gewichts range waaruit de target minimale afname of toename wordt bepaald ( indien het gewicht niet binnen de range is ) ";
	$pdf_text .= $LocalHulp; $LocalHulp = "";
	$LocalHulp .= "<br/><br/>" . "De gemeten buikomvang wordt gelegd tegen de gangbare tabellen voor buikomvang. Er is een separate tabel voor mannen en vrouwen.";
	$LocalHulp .= "<br/>" . "Buikomvang analyse";	
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes buikomvang vrouwen";
	foreach ( $this->setting [ 'buikvrouw' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s cm : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes buikomvang mannen";
	foreach ( $this->setting [ 'buikman' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s cm : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "De range verhoogd risico wordt aangenomen als de grenswaardes voor buikomvang.";
	$pdf_text .= $LocalHulp; $LocalHulp = "";
	$LocalHulp .= "<br/><br/>" . "Buikvet analyse: ";
	$LocalHulp .= "<br/>" . "Er is een algoritme gebaseerd op de BMI, leeftijd en man/vrouw. Deze wordt toegepast";
	$LocalHulp .= "<br/>" . "Er ook een algoritme rekening houdend met de lichaamsvorm ( appel of peer vorm ) berekend via de lengte, nekwijdte, heupwijdte en buikomvang en Man/vrouwg Deze wordt ook toegepast als de data beschikbaar is. ";
	$LocalHulp .= "<br/>" . "De resultaten van de twee berekeningen wordt gepresenteerd als als een range.";
	$LocalHulp .= "<br/>" . "Deze range wordt met de norm vergeleken voor een qualificatie.";
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes buikvet vrouwen 20- 40 jaar";
	foreach ( $this->setting [ '20vrouw' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s perc : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes buikvet mannen 20-40 jaar";	
	foreach ( $this->setting [ '20man' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s perc : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes buikvet vrouwen 40-60 jaar";
	foreach ( $this->setting [ '40vrouw' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s perc : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes buikvet mannen 40-60 jaar";	
	foreach ( $this->setting [ '40man' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s perc : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes buikvet vrouwen > 60 jaar";
	foreach ( $this->setting [ '60vrouw' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s perc : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes buikvet mannen > 60 jaar";	
	foreach ( $this->setting [ '60man' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s perc : %s", $key, $value ) ;
	$pdf_text .= $LocalHulp; $LocalHulp = "";
	$LocalHulp .= "<br/><br/>" . "Buikholte vet heeft een ander effect op de oe gezondheid als vet op de heupen. De MHR (middel-heup ratio) wordt berekend en gerapporteerd bij > als de grenswaarde ( MHR >95% voor mannen en MHR >80 voor vrouwen ).";
	$pdf_text .= $LocalHulp; $LocalHulp = "";
	$LocalHulp .= "<br/><br/>" . "Knijpkracht analyse: ";
	$LocalHulp .= "<br/>" . "De dominantie wordt bepaald ";
	$LocalHulp .= "<br/>" . "Alleen met de hoogste waarde wordt gewerkt en vergeleken met de normtabel 10percentiel. Deze is gedifferentieerd naar leeftijd en man / vrouw";
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes knijpkracht vrouwen ";	
	foreach ( $this->setting [ 'knijpvrouw' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s jaar : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Toegepaste grenswaardes knijpkracht mannen ";	
	foreach ( $this->setting [ 'knijpman' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "- tot %s jaar : %s", $key, $value ) ;
	$LocalHulp .= "<br/>" . "Als de BMI Normaal is worden een aantal qualificaties onderdrukt volgens geaccepteerde prioriteiten.";
	$pdf_text .= $LocalHulp; $LocalHulp = "";
	$LocalHulp .= "<br/><br/>" . "Calorie berekeningen: ";
	$LocalHulp .= "<br/>" . "Op basis van een algoritmes en de ingevoerde gegevens wordt bepaald het calorie verbruik als men helemaal niets doet ( BMR ). n.b. zelfs niet erover nadenkt !";
	$LocalHulp .= "<br/>" . "Afhankelijk van het aangegeven activiteiten niveau wordt een schatting gemaakt van het aantal calorieen dat men dagelijks nodig heeft. ";	
	foreach ( $this->setting [ 'beweging' ] as $key => $value ) 
		$LocalHulp .= "<br/>" . sprintf ( "factor %s x voor: %s", $this->setting [ 'beweging2' ] [ $key ], $value ) ;
	$pdf_text .= $LocalHulp; $LocalHulp = "";
	$prout .= $pdf_text;
	$pdf_text = "";

}

if ( in_array ( 1, $prmode ) ) { 
	if ($pdf_text != '</page>' ) $pdf_text = '</page>' ;
	$prout .= $pdf_text;
	$oPDF = lib_html2pdf::getInstance();
	$oPDF->setAuthor( "ContractHulp");
	$oPDF->setCreator( $this->setting [ 'droplet'] [ 'NL1'] );
	$oPDF->setTitle( $title );
	$oPDF->setSubject( $query );
	$oPDF->setKeywords ( $query );

	$oPDF->writeHTML( $prout );
	$oPDF->output($pdflink, 'F');
}
?>