<?php
/*
 *  @template       GSM_Lepton 7 Standard
 *  @version        see info.php of this template
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this template
 *  @license terms  see info.php of this template
 *  @platform       see info.php of this template
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php

/* deze table zit ook in het formulier 1an_form.lt e*/
$oFC->setting [ 'beweging' ] = array ( 
		'a0' => 'Geen of weinig beweging', 
		'a1' => '1-3 keer per week oefeningen', 
		'a2' => '4-5 keer per week oefeningen', 
		'a3' => 'Dagelijks oefeningen of 3-4 keer per week sport', 
		'a4' => '6-7 keer per week sport', 
		'a5' => 'Dagelijks flinke training of zwaar lichamelijk werk');

$oFC->setting [ 'beweging2' ] = array ( 
		'a0' => '1.2', 
		'a1' => '1.375', 
		'a2' => '1.465', 
		'a3' => '1.55', 
		'a4' => '1,725', 
		'a5' => '1.9');
			
$oFC->setting ['BMI'] = array (
			'16' => "Ondergewicht..",   
			'17' => "Ondergewicht. ",  
			'18.5' => "Ondergewicht", 
			'25' => "Normaal",	
			'27' =>	"Overgewicht",	
			'30' => "Licht Overgewicht", 
			'35' => "Matig Overgewicht", 
			'40' => "Ernstig Overgewicht", 			
			'100' => "Ziekelijk Overgewicht"); 
		
$oFC->setting ['BMI70']=array (  // aangepast voor boven de 70jaar
			'16' => "Ondergewicht..",   
			'17' => "Ondergewicht. ",  
			'22' => "Ondergewicht", 
			'28' => "Normaal",	
			'30' =>	"Overgewicht",	
			'40' => "Ernstig Overgewicht", 			
			'100' => "Ziekelijk Overgewicht"); 
		
$oFC->setting ['MHR']= "Buikholtevet % te hoog";
			
$oFC->setting ["buikman"]= array (
			'94' => "Laag risico",   //te lage buikomvang
			'100' => "Verhoogd risico",    // normale buikomvang
			'200' => "Sterk verhoogd risico ");	// te hoge buikomvang	
			
$oFC->setting ["20man"]= array (
			'8' => "Te laag",   
			'19.9' => "Normaal",   
			'25' => "Te hoog", 
			'100' => "Zeer hoog");
			
$oFC->setting ["20vrouw"]= array (
			'21' => "Te laag",   
			'33.9' => "Normaal",   
			'39' => "Te hoog", 
			'100' => "Zeer hoog");
			
$oFC->setting ["40man" ] = array (
			'11' => "Te laag",   
			'22.9' => "Normaal",   
			'28' => "Te hoog", 
			'100' => "Zeer hoog");
			
$oFC->setting ["40vrouw" ]=array (
			'23' => "Te laag",   
			'34.9' => "Normaal",   
			'40' => "Te hoog", 
			'100' => "Zeer hoog");
			
$oFC->setting ["60man"]= array (
			'13' => "Te laag",   
			'24.9' => "Normaal",   
			'30' => "Te hoog", 
			'100' => "Zeer hoog");
			
$oFC->setting ["60vrouw"]=array (
			'24' => "Te laag",   
			'36.9' => "Normaal",   
			'42' => "Te hoog", 
			'100' => "Zeer hoog");
			
$oFC->setting ["buikvrouw"]= array (
			'80' => "Laag risico",   //te lage buikomvang
			'90' => "Verhoogd risico",    // normale buikomvang
			'200' => "Sterk verhoogd risico ");	// te hoge buikomvang	

$oFC->setting ["knijpman" ]=array (  // 10 percentiel waarde
			'5' => 6,   
			'10' => 12,   
			'15' => 21, 
			'20' => 30,
			'25' => 36,
			'30' => 38,
			'35' => 39,
			'40' => 38,
			'45' => 36,
			'50' => 35,
			'55' => 34,
			'60' => 33,
			'65' => 31,
			'70' => 29,
			'75' => 26,
			'80' => 23,		
			'85' => 19,
			'90' => 16,
			'95' => 15 );
			
$oFC->setting ["knijpvrouw"]= array (  // 10 percentiel waarde
			'5' => 6,   
			'10' => 12,   
			'15' => 17, 
			'20' => 21,
			'25' => 23,
			'30' => 24,
			'35' => 23,
			'40' => 23,
			'45' => 22,
			'50' => 21,
			'55' => 19,
			'60' => 18,
			'65' => 17,
			'70' => 16,
			'75' => 14,
			'80' => 13,		
			'85' => 11,
			'90' => 9,
			'95' => 8 );
		
$oFC->setting ['antropo' ]= array (
		'z001' => "1950-01-01",		
		'z002' => "1925-01-01", 
		'z003' => "1940-01-01", 		
		't001' => "Voor documentatie en identificatie doeleinden", 
		't002' => "Geboortedatum voor berekening en identificatie, formaat jjjj-mm-dd", 
		't009' => "Geslacht voor berekening", 
		'b020' => "Gewicht voor berekening (in kg, decimalen toegestaan)", 
		'b021' => "Lengte voor berekening (in cm, decimalen toegestaan)", 
		'b022' => "Buikomvang voor berekening (in cm, decimalen toegestaan, te meten halverwege tussen onderkant ribben bovenkant heupbeen)",
		'b023' => "Nek wijdte voor berekening (in cm, decimalen toegestaan)",
		'b024' => "Heup wijdte voor berekening (in cm, decimalen toegestaan)",
		'b026' => "Handknijpkracht (in kg, decimalen toegestaan, hoogste waarde van de metingen)",
		'b025' => "Activiteit > Oefeningen = 15-30 min verhoogd hartritme, Sport = >40 minuten verhoogd hartritme, Training = >120 minuten verhoogd hartritme" ,
		'c002' => 0,   	
		'z020' => "75",
		'z021' => "175",
		'z022' => "100",
		'z023' => "40",
		'z024' => "100");

/* debug * / Gsm_debug ( array ( $oFC->setting ), __LINE__ . __FUNCTION__ ); /* debug */ 

/*check input values*/
if ( !$oFC->page_content [ 'P1' ] ) {
	/* debug * / Gsm_debug ( array ( $oFC->page_content ), __LINE__ . __FUNCTION__ ); /* debug */ 
	
	$oFC->page_content [ 'a020' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'a020' ] ?? "0", "v{". $oFC->setting ['antropo'] [ 'z020' ].";20;220}" );	
	$oFC->page_content [ 'a021' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'a021' ] ?? "0", "v{". $oFC->setting ['antropo'] [ 'z021' ].";20;220}" );	
	$oFC->page_content [ 'a022' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'a022' ] ?? "", "v{". "".";20;220}" );	
	$oFC->page_content [ 'a023' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'a023' ] ?? "", "v{". "".";20;220}" );	
	$oFC->page_content [ 'a024' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'a024' ] ?? "", "v{". "".";20;220}" );	
	$oFC->page_content [ 'a026' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'a026' ] ?? "0", "v{". "0;0;200}" );	
	$oFC->page_content [ 'a027' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'a027' ] ?? "0", "v{". "0;0;200}" );
	/* naam */	
//	$oFC->page_content [ 'a001' ] = $oFC->gsm_sanitizeStringS ( $oFC->page_content [ 'a001' ] , "s{ INPUT }" );
	/* geboortedatum */
	$oFC->page_content [ 'a002' ] = $oFC->gsm_sanitizeStringD ( $oFC->page_content [ 'a002' ] ?? $oFC->setting ['antropo'][ 'z001' ], "y{". $oFC->setting ['antropo'][ 'z001' ]. ";" . $oFC->setting ['antropo'][ 'z002' ] . ";" . $oFC->page_content [ 'DATE' ] ."}" );
	/* email */
	$oFC->page_content [ 'a003' ] = $oFC->gsm_sanitizeStringS ( $oFC->page_content [ 'a003' ] ?? "--", "s{ eMAIL }" );
	/* geslacht */
	$oFC->page_content [ 'a009' ] = $oFC->gsm_sanitizeStringS ( $oFC->page_content [ 'a009' ] ?? "", "s{ TOASC|CLEAN|TRIM } " );
}
?>