<?php
/*
 *  @template       GSM_Lepton Standard
 *  @version        see info.php of this module
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this module
 *  @platform       see info.php of this module
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php
 
$this->version ['2pdf1'] = "20251022";

$prmode = array ( 1 );  // ingevoerde gegevens
$prmode [] = 2;  // basis berekeningen
//if ( $this->page_content [ 'a007' ] )	$prmode []= 3; // Middel
//if ( $this->page_content [ 'a006' ] )	$prmode []= 4; // buikvet
//if  (isset ( $this->page_content [ 'a060' ] ) ) $prmode []= 5; // knijpkracht
//if ( $this->page_content [ 'a008' ] ) 	$prmode []= 6; // calorieverbruik
/* debug */ $prmode []= 9; 

$titel0 = explode ( "(", $title);
$titel = $titel0  [ 0 ];

/* opening printstream met css, header and footer */	
$prout  = "";
/* stylesheet */
$prout .= '<style>';
$prout .= 'h3 				{ color: #990000; font-style: italic; display: block; }
	h4 						{ color: #880088; font-style: italic; display: block; margin-bottom: 8mm; text-decoration: underline;}
	p.droplet 				{ height: 100mm; line-height: 5.25mm;   border: solid 1px #880000; width: 50%;}
	.gsm_example 			{ text-align: }
	th.gsm_example_center 	{ text-align: center; }
	.gsm_right 				{ text-align: right; }';
$prout .= '</style>';

$prout .= '<page footer="date,time" backtop="14mm" backbottom="14mm" backleft="15mm" backright="10mm" style="font-size: 12pt">';

/*header */
$prout .= '<page_header>
        <table class="page_header">
            <tr>
				<td style="width: 150mm;">
                   <h3>'. $titel .'</h3>
                </td>
                <td style="width: 50mm;">
                   <img src="[[ LEPTON_PATH ]]/modules/gsmofft/img/pdflogo.png" alt="" >
                </td>
            </tr>
        </table>
    </page_header>';
	
/* footer */	
$prout .= '<page_footer>
		<p style="text-align: right;">[[date_d]]-[[date_m]]-[[date_y]]  [[date_h]]:[[date_i]]:[[date_s]] Pagina [[page_cu]]/[[page_nb]] </p>
    </page_footer>';	
/* eind opening printstream  */

if ( isset ( $this->setting [ 'pdf_filename' ] ) && strlen ( $this->setting [ 'pdf_filename' ] ) > 10 ) {
	$printOK = true;
	$pdf_line = "";
	$pdf_text = "";
	$TEMPLATE0 = '<tr>
		<td style="width: 50mm;">%s</td>
		<td class="gsm_right" style="width: 70mm;">%s</td>
		<td style="width: 30mm;">%s</td></tr>';
	$TEMPLATE1 = '<tr>
		<td style="width: 60mm;">%s</td>
		<td class="gsm_right" style="width: 60mm;">%s</td>
		<td style="width: 30mm;">%s</td></tr>';
	$TEMPLATE2 = '<tr>
		<td style="width: 70mm;">%s</td>
		<td class="gsm_right" style="width: 50mm;">%s</td>
		<td style="width: 30mm;">%s</td></tr>';
	$TEMPLATE3 = '<tr>
		<td style="width: 80mm;">%s</td>
		<td class="gsm_right" style="width: 40mm;">%s</td>
		<td style="width: 30mm;">%s</td></tr>';
		
} else {
	$prmode = array ( );
}

if ( in_array ( 1, $prmode ) ) {
	$pdf_text .= '<h2>Berekening Transitievergoeding (ex artikel 7:673 BW)</h2>';
	$pdf_text .= '<bookmark title="Ingevoerde gegevens" level="0" ></bookmark>';
	$pdf_text .= '<bookmark title="Referenties" level="1" ></bookmark>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= sprintf ( $TEMPLATE1, "Naam werknemer : ", $this->page_content [ 'b001' ] , "");
	$pdf_text .= sprintf ( $TEMPLATE1, "Naam werkgeven : ", $this->page_content [ 'b010' ] , "");
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 1, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Werknemer" level="1" ></bookmark>';
	$pdf_text .= '<h3>Werknemer</h3>';
	$pdf_text .= '<table class="page_header" >';
	$pdf_text .= sprintf ( $TEMPLATE1, "Naam werknemer : ", $this->page_content [ 'b001' ] , "");
	$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'b002' ], "s{ DATUM }" ) ;
	$pdf_text .= sprintf ( $TEMPLATE1, "Geboortedatum : ", $LocalHulp , "");
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 1, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Dienstverband" level="1" ></bookmark>';
	$pdf_text .= '<h3>Dienstverband</h3>';
	$pdf_text .= '<table class="page_header" >';
	$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'b020' ], "s{ DATUM }" ) ;
	$pdf_text .= sprintf ( $TEMPLATE1, "Datum in dienst : ", $LocalHulp , "");
	$LocalHulp = $this->gsm_sanitizeStrings ( $this->page_content [ 'b021' ], "s{ DATUM }" ) ;
	$pdf_text .= sprintf ( $TEMPLATE1, "Datum uit dienst : ", $LocalHulp , "");
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 1, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Salaris" level="1" ></bookmark>';
	$pdf_text .= '<h3>Salaris</h3>';
	$pdf_text .= '<table class="page_header" >';
	$LocalHulp = $this->page_content [ 'b030' ];
	$pdf_text .= sprintf ( $TEMPLATE1, "Bruto maandsalaris : ", $LocalHulp , "");
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 2, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Berekening" level="0" ></bookmark>';	
	$pdf_text .= '<bookmark title="Duur dienstverband" level="1" ></bookmark>';
	$pdf_text .= '<h3>Duur dienstverband</h3>';
	$pdf_text .= '<table class="page_header" >';
	$LocalHulp = sprintf ( "%s jaren, %s maanden en %s dagen" , $this->page_content [ 'c020' ], $this->page_content [ 'c021' ], $this->page_content [ 'c022' ] );
	$pdf_text .= sprintf ( $TEMPLATE0, "Dienstverband : ", $LocalHulp , "");
	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}


if ( in_array ( 2, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Transitievergoeding" level="1" ></bookmark>';
	$pdf_text .= '<h3>Berekening transitievergoeding</h3>';
	$pdf_text .= '<table class="page_header" >';
	
	$this->page_content [ 'b030' ] = $this->gsm_sanitizeStringV ( $this->page_content [ 'b030' ] ?? "0", "v{0;0;200000}" );	
	$LocalHulp5=0;
	if ($this->page_content [ 'c020' ] >0 ) {
		$LocalHulp1 = $this->gsm_sanitizeStrings ( $this->page_content [ 'b030' ], "s{ KOMMA|EURO }" );
		$LocalHulp2 = sprintf ( "%s jaren x %s x 1/3" , $this->page_content [ 'c020' ], $LocalHulp1 );
		$LocalHulp3 = round ( $this->page_content [ 'b030' ] * $this->page_content [ 'c020' ] / 3, 2 );
		$LocalHulp4 = $this->gsm_sanitizeStrings ( $LocalHulp3, "s{ KOMMA|EURO }" );
			$LocalHulp5 =$LocalHulp5 + $LocalHulp3;
		$pdf_text .= sprintf ( $TEMPLATE3, $LocalHulp2, $LocalHulp4 , "");
	}

	if ($this->page_content [ 'c021' ] >0 ) {
		$LocalHulp1 = $this->gsm_sanitizeStrings ( $this->page_content [ 'b030' ], "s{ KOMMA|EURO }" );
		$LocalHulp2 = sprintf ( "%s maanden x %s x 1/3 x 1/12" , $this->page_content [ 'c021' ], $LocalHulp1 );
		$LocalHulp3 = round ( $this->page_content [ 'b030' ] * $this->page_content [ 'c021' ] / 36 , 2 );
		$LocalHulp4 = $this->gsm_sanitizeStrings ( $LocalHulp3, "s{ KOMMA|EURO }" );
		$LocalHulp5 =$LocalHulp5 + $LocalHulp3;
		$pdf_text .= sprintf ( $TEMPLATE3, $LocalHulp2, $LocalHulp4 , "");
	}
	if ($this->page_content [ 'c022' ] >0 ) {
		$LocalHulp1 = $this->gsm_sanitizeStrings ( $this->page_content [ 'b030' ], "s{ KOMMA|EURO }" );
		$LocalHulp2 = sprintf ( "%s dagen x %s x 1/3 x 1/365" , $this->page_content [ 'c022' ], $LocalHulp1 );
		$LocalHulp3 = round ( $this->page_content [ 'b030' ] * $this->page_content [ 'c022' ] / 3 / 365 , 2 );
		$LocalHulp4 = $this->gsm_sanitizeStrings ( $LocalHulp3, "s{ KOMMA|EURO }" );
		$LocalHulp5 =$LocalHulp5 + $LocalHulp3;
		$pdf_text .= sprintf ( $TEMPLATE3, $LocalHulp2, $LocalHulp4 , "");
	}
		if ($LocalHulp5 >0 ) {
		$LocalHulp1 = $this->gsm_sanitizeStrings ( $LocalHulp5, "s{ KOMMA|EURO }" );
		$pdf_text .= sprintf ( $TEMPLATE3, "", "------------" , " + ");
		$pdf_text .= sprintf ( $TEMPLATE3, "", $LocalHulp1 , "");
	}

	$prout .= $pdf_text;
	$prout .= '</table>';
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 2, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Exceptions" level="1" ></bookmark>';

	$LocalHulp1 = $LocalHulp5; //berekende transitievergoeding
	$LocalHulp2 = $this->page_content [ 'b030' ] * 12; // bruto jaarsalaris
	$LocalHulp3 = $this->gsm_sanitizeStringV ( $this->setting [ 'trans' ] [ 'c001' ] ?? "0", "v{0;0;200000}" ); // max transitievergoeding 
	
	if ( date ( "Y-m-d", strtotime ( $this->page_content [ 'c023' ] ) ) < $this->page_content [ 'b021' ]) {
		$pdf_text .= "<br/>". "Na pensioendatum is er geen transitievergoeding regeling";
		$LocalHulp1 = 0;
	}
	
	if ( $this->page_content [ 'b021' ] < "2020-01-01" )	{
		$pdf_text .= "<br/>". "Voor deze datum uit dienst is er een afwijkende regeling";
		$LocalHulp1 = 0;
	}
	
	/* case jaarsalaris boven max 
	berekende transitievergoeding groter als jaarsalaris */
	if ( $LocalHulp3 < $LocalHulp2 
		&& $LocalHulp2 < $LocalHulp1) {
		$LocalHulp1 = $LocalHulp2;
		$LocalHulp4 = $this->gsm_sanitizeStringV ( $LocalHulp1 , "s{ KOMMA|EURO }" );
		
		$LocalHulp5 = $this->gsm_sanitizeStringV ( $LocalHulp3 , "s{ KOMMA|EURO }" );
		$pdf_text .= sprintf ("<br/>De transitievergoeding is gemaximeerd op %s",
			$LocalHulp4); 
		$LocalHulp6 = $this->gsm_sanitizeStrings ( $this->page_content [ 'b030' ], "s{ KOMMA|EURO }" );
		$pdf_text .= sprintf ("<br/>( %s x 12 ) ", 
			$LocalHulp6); 
		
	} elseif ( $LocalHulp3 < $LocalHulp1 ) {
		$LocalHulp1 = $LocalHulp3;
		$LocalHulp4 = $this->page_content [ 'c003' ];
		$LocalHulp5 = $this->gsm_sanitizeStringV ( $LocalHulp3 , "s{ KOMMA|EURO }" );
		$pdf_text .= sprintf ("<br/>De transitievergoeding is in %s gemaximeerd op %s",
			$LocalHulp4, 
			$LocalHulp5); 
	}

	if ( $LocalHulp1 > 0 ) {
		$pdf_text .= '<h3>Transitievergoeding</h3>';
		$pdf_text .= '<table class="page_header" >';
		$LocalHulp5 = $this->gsm_sanitizeStrings ( $LocalHulp1, "s{ KOMMA|EURO }" ); 
		$pdf_text .= sprintf ( $TEMPLATE3, "", $LocalHulp5 , "");
		$pdf_text .= sprintf ( $TEMPLATE3, "", "===========" , "");
		$pdf_text .= '</table>';
	}
	$prout .= $pdf_text;
	$pdf_text = ""; // $pdf_text = '</page>';
}
if ( in_array ( 1, $prmode ) ) {
	if ($pdf_text == '</page>' ) $pdf_text .= '<page pageset="old" style="font-size: 12pt">';
	$pdf_text .= '<bookmark title="Verantwoording" level="0" ></bookmark>';
	$LocalHulp = "Dit antropometrie overzicht is "; 
	if ( LOAD_OLINE ) {
		$LocalHulp .= sprintf ( "on-line via %s" , LEPTON_URL );
	} else {
		$LocalHulp .= "off-line";
	}
	$LocalHulp .= " gemaakt op : " . $this->gsm_sanitizeStrings ( date ( "d M Y", time ( ) ), "s{ DATUM }" ). "." ; 

	$LocalHulp .= "<br/>" . "De berekeningen en uitspraken, gedaan op basis van de ingevoerde gegevens en verwerkt volgens de gangbare normen en algoritmes, zijn met zorgvuldigheid gedaan. ";
	$LocalHulp .= "<br/>" . $this->setting [ 'droplet' ] [ 'NL2' ] . " aanvaardt geen enkele aansprakelijkheid naar aanleiding van deze berekening en de uitspraken." ; 
	$LocalHulp .= "<br/>" . "Heeft u vragen of opmerkingen, neem dan gerust contact op : "; 
	$LocalHulp .= "<br/>" . $this->setting [ 'droplet' ] [ 'NL2' ] . "<br/>" . " Web: ". $this->setting [ 'droplet' ] [ 'NL1' ]; 
	$pdf_text .= "<h5>" . $LocalHulp . "</h5>";

	$prout .= $pdf_text;
	$pdf_text = ""; // $pdf_text = '</page>';
}

if ( in_array ( 1, $prmode ) ) { 
	if ($pdf_text != '</page>' ) $pdf_text = '</page>' ;
	$prout .= $pdf_text;
	$oPDF = lib_html2pdf::getInstance();
	$oPDF->setAuthor( "ContractHulp");
	$oPDF->setCreator( $this->setting [ 'droplet'] [ 'NL1'] );
	$oPDF->setTitle( $title );
	$oPDF->setSubject( $query );
	$oPDF->setKeywords ( $query );

	$oPDF->writeHTML( $prout );
	$oPDF->output($pdflink, 'F');
}
?>
