<?php
/*
 *  @template       GSM_Lepton 7 Standard
 *  @version        see info.php of this template
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this template
 *  @license terms  see info.php of this template
 *  @platform       see info.php of this template
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php


$oFC->setting [ 'trans' ] = array ( 
		't001' => "Voor documentatie en identificatie doeleinden", 
		't002' => "Geboortedatum voor berekening en identificatie, formaat jjjj-mm-dd", 
		't020' => "Eerste dag in dienst, formaat jjjj-mm-dd", 
		't021' => "Laatste dag in dienst, formaat jjjj-mm-dd", 
		't030' => "Bruto maandsalaris + 1/12 deel van vakantiegeld, bonus, 13e maand en overwerk",	
		'c001' => "98000",   // max jaarsalaria	
		'c002' => "1950-01-01",  
		
		'c003' => "2025"	);	// jaar
		
/* debug * / Gsm_debug ( array ( $oFC->page_content, $oFC->setting ), __LINE__ . __FUNCTION__ ); /* debug */ 

/*check input values*/
if ( !$oFC->page_content [ 'P1' ] ) {
	/* debug * / Gsm_debug ( array ( $oFC->page_content ), __LINE__ . __FUNCTION__ ); /* debug */ 

	$oFC->page_content [ 'c001' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'c001' ] ?? "0", "v{0;0;100000}" );	
	$oFC->page_content [ 'b030' ] = $oFC->gsm_sanitizeStringV ( $oFC->page_content [ 'b030' ] ?? "0", "v{0;0;200000}" );	
	$oFC->page_content [ 'b001' ] = $oFC->gsm_sanitizeStringS ( $oFC->page_content [ 'b001' ] ?? "--", "s{ INPUT } " );
	$oFC->page_content [ 'b010' ] = $oFC->gsm_sanitizeStringS ( $oFC->page_content [ 'b010' ] ?? "--", "s{ INPUT } " );
	$oFC->page_content [ 'b002' ] = $oFC->gsm_sanitizeStringD ( $oFC->page_content [ 'b002' ] ?? "0", "y{". $oFC->setting ['trans'][ 'c002' ]. ";" . $oFC->setting ['trans'][ 'c002' ] . ";" . $oFC->page_content [ 'DATE' ] ."}" );
	$oFC->page_content [ 'b020' ] = $oFC->gsm_sanitizeStringD ( $oFC->page_content [ 'b020' ] ?? "0", "y{". $oFC->page_content [ 'DATE' ] .";1970-01-01;". $oFC->page_content [ 'DATE' ] ."}" );	
	$oFC->page_content [ 'b021' ] = $oFC->gsm_sanitizeStringD ( $oFC->page_content [ 'b021' ] ?? "0", "y{". $oFC->page_content [ 'DATE' ] . ";" . $oFC->page_content [ 'b020' ] . ";" . $oFC->page_content [ 'DATEHIGH' ]  . "}" );

}

/* update jaarmax */

if ( !$oFC->page_content [ 'P1' ] ) {
	if ( isset ( $oFC->setting [ 'transmx' ] ) ) {
		foreach ( $oFC->setting [ 'transmx' ] as $key => $value ) {
			if ( $oFC->page_content [ 'b021' ] >= $key && substr ( $key, 0, 4 ) > $oFC->setting [ 'trans' ] [ 'c003' ] ) {
				$oFC->setting [ 'trans' ] [ 'c003' ] = substr ( $key, 0, 4 );
				$oFC->setting [ 'trans' ] [ 'c001' ] = $value;
				$oFC->page_content [ 'c001' ] = $value;
			}
		}
	}
}

/* debug * / Gsm_debug ( array ( $oFC->page_content,   $oFC->setting ), __LINE__ . __FUNCTION__ ); /* debug */ 
