<?php
/*
 *  @template       GSM_Lepton 7 Standard
 *  @version        see info.php of this template
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this template
 *  @license terms  see info.php of this template
 *  @platform       see info.php of this template
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php

/* Module id */ 
$module_name = LOAD_MODE. 'antropometrie';
$version = 'v20250817';
$main_file = "party";
$project = "Antropometrie Analyse";
$default_template = 'an';

/* Initialize module */
global $oLEPTON, $section_id, $database, $page_id;
$oFC = gsmoffc::getInstance();
$oTWIG = lib_twig_box::getInstance ( );
$oTWIG-> registerModule ( LOAD_MODULE . LOAD_SUFFIX );

/* Version data */
$oFC->version [ $module_name ] = $version;
$oFC->version = array_merge ( $oFC->version, $version_display);
$oFC->version [ $oFC-> language [ 'LANG' ] ] = $oFC-> language [ 'VERS' ];
$oFC->version [ "set" ] = $FC_SET [ 'version' ] ;

/* Settings */
$oFC->setting [ 'includes' ] 		= $place [ 'includes' ];
$oFC->setting [ 'frontend' ] 		= $place [ 'frontend' ];
$oFC->setting [ 'PAGE_ID' ] 		= $page_id ?? 0;
$oFC->gsm_initTaxi ( LOAD_MODULE . LOAD_SUFFIX, $oFC->user [ 'privileged' ], $FC_SET, array ( "setting", "droplet"  ) );

/* Limited use */
$oFC->page_content [ 'MODE' ] = 9;
if ( $oFC->user [ 'privileged' ] > 0 ) {
	$oFC->gsm_adresDet ( $oFC->setting [ 'PAGE_ID' ], $oFC->setting [ 'owner' ] ) ;
	if ($oFC->user[ 'privileged' ] > 2 ) {
		$oFC->page_content [ 'MODE' ] = 9;
		/* reload some settings */
		$oFC->gsm_initTaxi ( LOAD_MODULE . LOAD_SUFFIX, $oFC->user [ 'privileged' ], $FC_SET, "setting" );
}	}

/* File references */
$oFC->file_ref [ 99 ] = sprintf ( "%s_%s_%s", 
	LOAD_DBBASE, 
	$oFC->setting [ 'PAGE_ID' ], 
	$main_file);

/* Default values */
$oFC->page_content [ 'MODULE' ] = $module_name;
$oFC->page_content [ 'PAGE_ID' ] = $page_id ?? 0;
$oFC->page_content [ 'SECTION_ID' ] = $section_id ?? 0;
/* $project= sprintf ("%s ( %s )" , $project, $oFC->page_content [ 'PAGE_ID' ] ) ; */
$oFC->page_content [ 'FORMULIER' ] = $project;
$oFC->page_content [ 'ICON' ] = 'weight icon';
$template_name= '@' . LOAD_MODULE . LOAD_SUFFIX . "/". LANGUAGE . sprintf ("/%s%s_form.lte", 
	$oFC->setting [ 'PAGE_ID' ] , 
	$default_template);

/* procesdefaults 1 */
$oFC->page_content [ 'DATEHIGH' ] = ( date ( "Y-m-d", mktime ( 0, 0, 0, date ( "m" ) + 24, '01', date ( "Y" ) ) ) );
$oFC->page_content [ 'pdf_location' ] = sprintf ( "%s/%s/XX_%s/", $oFC->setting [ 'collectdir' ], date ("Y-m-d"), session_id ( ) );
$oFC->page_content [ 'gebruik' ] = '';

/* Create condition for sips test */
$_SESSION [ 'page_h' ] = $oFC->page_content ['HASH'];

/* Get memory values 
 *  func 0 retrieve from directory or post
 *  func 1 retrieve from post or directory
 * /
$oFC->gsm_memorySaved ( );

/* debug * / Gsm_debug (array ( "post"=>		 $_POST, "get"=>$_GET ?? "", $xmode , $selection ), __LINE__ . "post" ); /* end */
/* debug * / Gsm_debug (array ( "user"=>	$oFC->user ), __LINE__ . "user" ); /* end */ 
/* debug * / Gsm_debug (array ( "setting"=>	$oFC->setting  ), __LINE__ ."setting" ); /* end */ 
/* debug * / Gsm_debug (array ( "files"=>	$oFC->file_ref  ), __LINE__ . "files" ); /* end */ 
/* debug * / Gsm_debug (array ( "talen"=>	$oFC->language  ), __LINE__ . "talen" ); /* end */
/* debug * / Gsm_debug (array ( "content"=>	$oFC->page_content ), __LINE__ . "content" ); /* end */ 

/* reset before job */ 
if ( isset( $_POST[ 'command' ] ) && $_POST [ 'command' ] == "Reset" ) { 
	unset ($_POST); 
	$oFC->description .= $oFC->gsm_message ( __LINE__ , $oFC->language [ 'TXT_REMOVE_INPUT' ] ); 
}

/* which job to do */
if ( isset( $_POST[ 'command' ] ) ) {
	$oFC->page_content [ 'P1' ] = false; // niet eerste cycle 
	foreach ($_POST as $pay =>$load ) {	
		if (substr ( $pay, 0, 4 ) == "gsm_" ) {
			$oFC->page_content [ substr ( $pay, 4 ) ] = $oFC->gsm_sanitizeStringS ( $load ?? "" , "s{INPUT}" );	
	}	}
	
	/* externe checks on input values */ 
	$check = $oFC->setting [ 'includes' ] . 'v'.substr ( $module_name , 1 ) . '_check' . '1' . '.php';
	if ( file_exists ( $check ) ) require_once ( $check ); 	
	$oFC->page_content = array_merge ( $oFC->page_content, $oFC->setting [ 'antropo'] );
	
	/* jobs */ 
	switch ( $_POST[ 'command' ] ) {
		case "Reset":
			$oFC->page_content [ 'MODE' ] = 9;
			$oFC->page_content [ 'P1' ] = true; // eerste cycle 
			break;
		case "Print":
			$oFC->setting [ 'pdf_filename' ] = $oFC->gsm_sanitizeStrings ( sprintf ( "antropometrie_%s_%s.pdf", 
					date ( "Ymd", time ( ) ), 
					$oFC->page_content [ 'b001' ] ), 
					"s{FILE}" );
		default:
			$oFC->page_content [ 'MODE' ] = 9;
			break;
	} 
} elseif ( isset( $_GET[ 'command' ] ) ) {
	switch ( $_GET[ 'command' ] ) {	
		default:
			// escape route 
			$oFC->page_content [ 'P1' ] = true; // eerste cycle aangenomen
			$oFC->page_content [ 'MODE' ] = 9;
			break;
	} 
} else {
	$oFC->page_content [ 'MODE' ] = 9;
	$oFC->page_content [ 'P1' ] = true; // eerste cycle 
	$oFC->gsm_existDir ( $oFC->page_content [ 'pdf_location' ] , true  );
}

// einde input verwerking
/* debug * / Gsm_debug (array ( "this"=>$oFC), __LINE__ . __FUNCTION__ ); /* end */

/* opmaak voor de uitvoer */
if ( !$oFC->page_content [ 'P1' ] ) {
	
	// screenuitvoer en berekening */
	$check = $oFC->setting [ 'includes' ] . 'v'.substr ( $module_name , 1 ) .  '_check' . '2' . $oFC->page_content [ 'gebruik' ] . '.php';
	if ( file_exists ( $check  ) ) require_once ( $check ); 

	/* printuitvoer */
	$oFC->setting [ 'pdf_filename' ] = $oFC->gsm_sanitizeStrings ( sprintf ( "antropometrie_%s_%s.pdf", 
			date ( "Ymd", time ( ) ), 
			$oFC->gsm_sanitizeStringS ( $oFC->page_content [ 'a001' ], "s{TOASC|LOWER}" ) ), "s{FILE}" );
	if ( isset ( $oFC->setting [ 'pdf_filename' ] ) && strlen ( $oFC->setting [ 'pdf_filename' ] ) > 10 ) 
		$oFC->gsm_print ( "", 
			$project, "" , 
			"1" . $oFC->page_content [ 'gebruik' ], 
			$oFC->page_content [ 'pdf_location' ]  );
} else {
	/* we hebben de settings nodig */ 
	$check = $oFC->setting [ 'includes' ] . 'v'.substr ( $module_name , 1 ) . '_check' . '1' . '.php';
	if ( file_exists ( $check ) ) require_once ( $check ); 	
	$oFC->page_content = array_merge ( $oFC->page_content, $oFC->setting [ 'antropo'] );
}

/* the selection options */
switch ( $oFC->page_content [ 'MODE' ] ) {
	default: 
		$oFC->page_content [ 'SELECTIONA' ] = $oFC->gsm_opmaakSel ( array ( 7 ) );
		$oFC->page_content [ 'SELECTIONB' ] = $oFC->gsm_opmaakSel ( array ( 6 ) );
		if ( !$oFC->page_content [ 'P1' ] ) {
			$oFC->page_content [ 'SELECTIONX' ] = str_replace ( "---", "", $oFC->page_content [ 'pdf_location' ] . $oFC->setting [ 'pdf_filename' ]);
			$oFC->page_content [ 'SELECTIONC' ] = $oFC->gsm_opmaakSel ( array ( 11 ), 
				"-", 
				$oFC->setting [ 'pdf_filename' ], 
				"-", "-", "-", "-", 
				$oFC->page_content [ 'pdf_location' ] );
			if ( $oFC->user [  "privileged" ] >0 ) {
				$oFC->page_content [ 'SELECTIONC' ] .= '<br /><button class="ui blue basic button" name="command" value="Email" type="submit"><i class="mail icon"></i> Mail naar :</button>';
				$oFC->page_content [ 'SELECTIONC' ] .= sprintf ( '<div class="ui transparent input"><input type="text" name="gsm_email" value="%s" /> </div>', $oFC->page_content  [  "d001" ] );
			}
			/* end mail met attachment */	
		}
		$oFC->page_content [ 'SELECTIOND' ] = $oFC->gsm_opmaakSel ( array ( 6, 7 ) );
		break; 	
}

/* the output to the screen */
if ( $oFC->page_content [ 'P1' ] ) { 
	$oFC->page_content [ 'REFERENCE_ACTIVE1'] = 'active'; 
	$oFC->page_content [ 'REFERENCE_ACTIVE2'] = ''; 
	$oFC->page_content [ 'REFERENCE_ACTIVE3'] = ''; 
} else {
	$oFC->page_content [ 'REFERENCE_ACTIVE1'] = ''; 
	$oFC->page_content [ 'REFERENCE_ACTIVE2'] = 'active'; 
	$oFC->page_content [ 'REFERENCE_ACTIVE3'] = ''; 
}

/* Output processing */
/* Memory save * /
$oFC->page_content ['MEMORY'] = $oFC->gsm_memorySaved ( ); 

/* Messages to show */
$oFC->page_content[ 'STATUS_MESSAGE' ] .= $oFC->description; 
if (strlen($oFC->page_content[ 'STATUS_MESSAGE' ])>4 ) $oFC->page_content['MESSAGE_CLASS']= "ui error message"; 
$oFC->page_content[ 'VERSIE' ] = $oFC->version; 
if (LOAD_MODE == "x" )  $_SESSION[ 'last_edit_section' ] = $section_id; 

/* Output handling * /
switch ( $oFC->page_content [ 'MODE' ] ) {
	default: 
		break;
} /* end */

/* Actual output */
echo $oTWIG->render( 
	$template_name, // template-filename
    $oFC->page_content // template-data
);
/* End output processing */

/* debug * /  Gsm_debug ($oFC->page_content, __LINE__ . $template_name ); 
if (LOAD_MODE == "x" )  Gsm_debug ($oFC->version, $template_name ); /* end */ 
?>