<?php
/*
 *  @template       GSM_Lepton 7 Standard
 *  @version        see info.php of this template
 *  @author         Gerard Smelt
 *  @copyright      2014-2025 ContractHulp
 *  @license        see info.php of this template
 *  @license terms  see info.php of this template
 *  @platform       see info.php of this template
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {  
  include LEPTON_PATH.SEC_FILE;
} else {
  $oneback = "../";
  $root = $oneback;
  $level = 1;
  while (($level < 10) && (!file_exists($root.SEC_FILE))) {
    $root .= $oneback;
    $level += 1;
  }
  if (file_exists($root.SEC_FILE)) { 
    include $root.SEC_FILE;   
  } else {
    trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
  }
}
// end include secure.php

/* module id*/ 
$module_name = 'xsetupc';
$version = '20250803';
$main_file = "party";
$default_template = '/back.lte';
$project= "Instellingen";

/* start initialize module */
global $oLEPTON;
$oFC = gsmoffc::getInstance();
$oTWIG = lib_twig_box::getInstance ( );
$oTWIG-> registerModule ( LOAD_MODULE . LOAD_SUFFIX );
$template_name= '@' . LOAD_MODULE . LOAD_SUFFIX . "/". LANGUAGE . $default_template;

/* version data */
$oFC->version [ $module_name ] = $version;
$oFC->version = array_merge ( $oFC->version, $version_display);
$oFC->version [ $oFC-> language [ 'LANG' ] ] = $oFC-> language [ 'VERS' ];
$oFC->version [ "set" ] = $FC_SET [ 'version' ] ;
// $project= sprintf ("%s %s " , $oFC-> language [ 'TXT_SETUP' ], strtoupper ( $main_file )) ;

/* Settings */
$oFC->setting [ 'includes' ] 		= $place [ 'includes' ];
$oFC->setting [ 'frontend' ] 		= $place [ 'frontend' ];
$oFC->setting [ 'PAGE_ID' ] 		= $page_id ?? 0;
$oFC->gsm_initTaxi ( LOAD_MODULE . LOAD_SUFFIX, $oFC->user [ 'privileged' ], $FC_SET, array ( "setting", "zoek", "droplet" ) );

/* Limited use */
$oFC->page_content [ 'MODE' ] = 9;
if ( $oFC->user [ 'privileged' ] > 0 ) {
	$oFC->gsm_adresDet ( $oFC->setting [ 'PAGE_ID' ], $oFC->setting [ 'owner' ] ) ;
	if ($oFC->user[ 'privileged' ] > 2 ) {
		$oFC->page_content [ 'MODE' ] = 9;
		/* reload some settings */
		$oFC->gsm_initTaxi ( LOAD_MODULE . LOAD_SUFFIX, $oFC->user [ 'privileged' ], $FC_SET, "setting" );
		/*	logged in as administrator privileged = 3
		 *	logged in met view rechten = 2 
		 *	logged in privileged = 1
		 *	not logged in privileged = 0
		 */
}	}

/* File references */
$oFC->file_ref [ 99 ] = sprintf ( "%s_%s_%s", 
	LOAD_DBBASE, 
	$oFC->setting [ 'PAGE_ID' ],
	$main_file);

/* Default values */
$oFC->page_content [ 'MODULE' ] = $module_name;
$oFC->page_content [ 'PAGE_ID' ] = $page_id ?? 0;
$oFC->page_content [ 'SECTION_ID' ] = $section_id ?? 0;
$project= sprintf ("%s %s ( %s )" , 
	$oFC-> language [ 'TXT_SETUP' ], 
	strtoupper ( $main_file ?? "" ) , 
	$oFC->page_content [ 'PAGE_ID' ] ) ;
$oFC->page_content [ 'FORMULIER' ] = $project;

/* Create condition for sips test */
$_SESSION [ 'page_h' ] = $oFC->page_content ['HASH'];

/* Get memory values 
 *  func 0 retrieve from directory or post
 *  func 1 retrieve from post or directory
 * /
$oFC->gsm_memorySaved ( );

/* debug * / Gsm_debug (array ( "post"=>		 $_POST, "get"=>$_GET ?? "", $xmode , $selection ), __LINE__ . "post" ); /* end */
/* debug * / Gsm_debug (array ( "user"=>	$oFC->user ), __LINE__ . "user" ); /* end */ 
/* debug * / Gsm_debug (array ( "setting"=>	$oFC->setting  ), __LINE__ ."setting" ); /* end */ 
/* debug * / Gsm_debug (array ( "files"=>	$oFC->file_ref  ), __LINE__ . "files" ); /* end */ 
/* debug * / Gsm_debug (array ( "talen"=>	$oFC->language  ), __LINE__ . "talen" ); /* end */
/* debug * / Gsm_debug (array ( "content"=>	$oFC->page_content ), __LINE__ . "content" ); /* end */

/* Selection functions * /
if ( !isset ( $xmode ) ) $xmode = "";
if ( isset ( $selection ) && strlen ( $selection ) > 1 ) {
	$selection = strtolower ( $selection );
	foreach ( array( "print" => "print" ,   // simple printout of relevant records
	"part" => "part") as $pay => $load ) {	// specific printout
		if ( strstr ( $selection, $pay ) ) {
			$xmode .= $load; 
			$selection = trim ( str_replace ( $pay, "", strtolower ( $selection ) ) );
}	}	}

/* Multiple keyword selection * /
$oFC->search_mysql = "";
if ( isset ( $selection ) && strlen ( $selection ) > 2 ) {
	$LhulpA = explode (" ", trim ( $selection ));
	$first= true;
	foreach ($LhulpA as $value) {
		if ($first) { $oFC->search_mysql .= " WHERE "; } else { $oFC->search_mysql .= " AND "; }
		$help = "%" . str_replace ( "_", "" , str_replace ( "?", "", trim ( $value ) ) ) . "%";
		$oFC->search_mysql .= "`zoek` LIKE '" . $help . "'";
		$first= false;
	}
} else { 
	$selection = "";
}	
$oFC->page_content [ 'PARAMETER' ] = trim ( $selection );
$oFC->page_content [ 'SUB_HEADER' ] = strtoupper ( $oFC->page_content [ 'PARAMETER' ] );


/* Sips test before job */ 
if ( isset( $_POST[ 'command' ] ) && $oFC->sips) { 
	unset ($_POST); 
	$oFC->description .= $oFC->gsm_message ( __LINE__ , $oFC->language [ 'TXT_ERROR_SIPS' ] ); 
}

/* Print function * /
if ( strstr ( $xmode, "print") || strstr ( $xmode, "part" ) ) 
	$oFC->setting ['pdf_filename'] = $oFC->gsm_sanitizeStringS ( str_replace ( " .", ".", 
		sprintf ( "Overzicht %s%s %s.%s", 
			$main_file,  
			$oFC->page_content [ 'PAGE_ID' ], 
			$oFC->page_content  [ 'PARAMETER' ], 
			"pdf")) , "s{FILE}" );

/* Input processing */
if ( isset( $_POST[ 'command' ] ) ) {
	switch ( $_POST[ 'command' ] ) {
		/* next * /
		case "up":
			$oFC->page_content [ 'position' ] = $oFC->gsm_pagePosition ("up", $oFC->page_content [ 'position' ] , $_POST[ 'n2' ],  $oFC->setting [ 'qty_max' ], $_POST[ 'n0' ], $_POST[ 'n1' ] );
			break;
		/* previous * /
		case "down":
			$oFC->page_content [ 'position' ] = $oFC->gsm_pagePosition ("down", $oFC->page_content [ 'position' ] , $_POST[ 'n2' ], $oFC->setting [ 'qty_max' ], $_POST[ 'n0' ], $_POST[ 'n1' ] );
			break;
		/* select * /
		case "Select":
		case "View":
			if ( !isset( $_POST[ 'vink' ][ 0 ] ) ) 	break;
			$oFC->page_content [ 'MODE' ] = 8;
			$oFC->recid = $_POST[ 'vink' ][ 0 ];
			break;
		/* save * /
		case "Save":
			$oFC->page_content [ 'MODE' ] = 9;
			$oFC->recid = $_POST [ 'gsm_id' ];
			$FieldArr = array ();
			$FieldArr [ 'name'] = $oFC->gsm_sanitizeStringNA ( 3, 'name', $_POST [ 'gsmc_name1' ] ?? "" , $_POST [ 'gsmc_name2' ] ?? "", $_POST [ 'gsmc_name3' ] ?? "" , $_POST [ 'gsmc_name4' ] ?? "");	
			$FieldArr [ 'adres'] = $oFC->gsm_sanitizeStringNA ( 3, 'adres', $_POST [ 'gsmc_adres1' ] ?? "" , $_POST [ 'gsmc_adres2' ] ?? "", $_POST [ 'gsmc_adres3' ] ?? "" , $_POST [ 'gsmc_adres4' ] ?? "");
			$FieldArr [ 'ref'] =  $_POST [ 'gsmc_ref' ] ?? "XX" . $_POST [ 'gsm_id' ] ?? $_POST [ 'gsm_recid' ] ;			
			$oFC->page_content [ 'ACCESS'] = $oFC->gsm_accessRec ( $FieldArr, $oFC->recid, 1, $main_file );
			$oFC->page_content [ 'ACCESS'] = array_merge ( $oFC->page_content [ 'ACCESS'] , $oFC->gsm_sanitizeStringNA ( 2, 'name' , $oFC->page_content [ 'ACCESS'] [ 'name' ] ) ) ;
			$oFC->page_content [ 'ACCESS'] = array_merge ( $oFC->page_content [ 'ACCESS'] , $oFC->gsm_sanitizeStringNA ( 2, 'adres' , $oFC->page_content [ 'ACCESS'] [ 'adres' ] ) ) ;
			break;
		/* save as new * /
		case "New":
			$oFC->page_content [ 'MODE' ] = 9;
			$oFC->recid = $_POST [ 'gsm_id' ];
			$result = array();
			$database->execute_query( 
				sprintf ("SELECT * FROM `%s` WHERE `email` = '%s'", $oFC->file_ref [ 99 ], $_POST [ 'gsm_email' ] ),
				true, 
				$result);
			if ( count ( $result ) == 0 || $_POST [ 'gsm_email' ] == "" ) { 
				$FieldArr = array ();
				$FieldArr [ 'name'] = $oFC->gsm_sanitizeStringNA ( 3, 'name', $_POST [ 'gsmc_name1' ] ?? "" , $_POST [ 'gsmc_name2' ] ?? "", $_POST [ 'gsmc_name3' ] ?? "" , $_POST [ 'gsmc_name4' ] ?? "");
				$FieldArr [ 'adres'] = $oFC->gsm_sanitizeStringNA ( 3, 'adres', $_POST [ 'gsmc_adres1' ] ?? "" , $_POST [ 'gsmc_adres2' ] ?? "", $_POST [ 'gsmc_adres3' ] ?? "" , $_POST [ 'gsmc_adres4' ] ?? "");
				$FieldArr [ 'ref'] =  $_POST [ 'gsmc_ref' ] ?? "XX";			
				$oFC->page_content [ 'ACCESS'] = $oFC->gsm_accessRec ( $FieldArr, $oFC->recid, 2, $main_file );
				$oFC->page_content [ 'ACCESS'] = array_merge ( $oFC->page_content [ 'ACCESS'] , $oFC->gsm_sanitizeStringNA ( 2, 'name' , $oFC->page_content [ 'ACCESS'] [ 'name' ] ) ) ;
				$oFC->page_content [ 'ACCESS'] = array_merge ( $oFC->page_content [ 'ACCESS'] , $oFC->gsm_sanitizeStringNA ( 2, 'adres' , $oFC->page_content [ 'ACCESS'] [ 'adres' ] )) ;
			} else {
			$oFC->description .= $oFC->gsm_message ( __LINE__ , $oFC->language [ 'TXT_ACTIVE_DATA' ]);
			$oFC->page_content [ 'MODE' ] = 9;
			}
		/* reset * /
		case "Reset":
			$oFC->recid = '';
			$oFC->search_mysql = "";
			$selection= "";
			$oFC->page_content [ 'PARAMETER' ] = $selection;
			$oFC->page_content [ 'SUB_HEADER' ]= "____";
		/* post exit */
		default:
			$oFC->page_content [ 'MODE' ] = 9;
			break;
	} 
} elseif ( isset( $_GET[ 'command' ] ) ) {
	switch ( $_GET[ 'command' ] ) {
		/*select data * /
		case 'select': //    1=>'Wijzigen', 
			// is a record selected ? 
			if ($oFC->recid == "") { 
				$oFC->page_content [ 'MODE' ] = 9; 
				$oFC->description .= $oFC->MOD_GSMOFF ['MSG_NO_DATA'];
				break;
			} 
			$oFC->recid = $_GET[ 'recid' ];
			$oFC->page_content [ 'MODE' ] = 8; 
			break;
		/* Delete data * /
		case 'remove': //    
			if ($oFC->recid == "") { 
				$oFC->page_content [ 'MODE' ] = 9; 
			} else {
				$oFC->page_content [ 'MODE' ] = 9;
				$FieldArr = array ();
				$oFC->page_content [ 'RESULT'] = $oFC->gsm_accessRec ( $FieldArr, $oFC->recid, 3, $main_file );
				$oFC->recid = "";
			}
			break;
		/* get exit */
		default:
			// escape route 
			$oFC->page_content [ 'MODE' ] = 9;
			break;
	} //$_GET[ 'command' ]
} else {
	/* first run */
	$oFC->page_content [ 'P1' ] = true;
	
	/* Default settings */
	$job = array ();
		
	foreach ( $oFC->file_ref as $LocalHulp ) {
		$payload = $place[ 'includes'] . str_replace ( $oFC->page_content [ 'PAGE_ID' ]."_" , "", str_replace ( TABLE_PREFIX, "setup_", $LocalHulp )) . ".php";
		if ( file_exists ( $payload ) ) { 
			include ( $payload ); 
		} else {
			$oFC->description .= $oFC->gsm_message ( __LINE__ ,  ' No Upgrade function ' . $LocalHulp ); 
		}
	}
	/* create directories */
//	$oFC->gsm_existDir ( sprintf ('%s%s' ,LEPTON_PATH , $oFC->setting [ 'collectdir' ] ), true );
//	$oFC->gsm_existDir ( sprintf ('%s%s' ,LEPTON_PATH , $oFC->setting [ 'mediadir' ] ), true );
}
/* End! which job to do now*/

/* debug * / Gsm_debug (array ("this"=>$oFC  ), __LINE__ . __FUNCTION__ ); /* debug */ 

/* Additional functions */
if ( isset ( $oFC->setting [ 'pdf_filename' ] )  && strlen( $oFC->setting [ 'pdf_filename' ] ) > 5 ) {
	if ( strstr ( $xmode, "part" )) {
		$pdflink = $oFC->gsm_print ( $oFC->page_content  [ 'PARAMETER' ] , $project, $xmode , 2 );
		$oFC->page_content  [ 'PARAMETER' ] ="";
	} else {		
		$pdflink = $oFC->gsm_print ( $oFC->page_content  [ 'PARAMETER' ] , $project, $xmode , 1 );
	}
} else {
	if (LOAD_MODE == "x" && isset ( $xmode ) && strlen ( $xmode ) >3 ) require_once ( $place[ 'includes'] . 'repair.php' );
}

// display preparation
switch ( $oFC->page_content [ 'MODE' ]  ) {
	case 0:
		break;
	case 8:
		$oFC->page_content [ 'MODE' ] = 9;
	default: // default list
		$results = array();
		$cal = array();
		$job = array();
		/* eind main routine */
		$oFC->page_content [ 'RESULTS' ] = $cal;
		break;
}
/* end display processing */

/* display selection options */
$oFC->page_content [ 'SELECTION' ] = "";
$oFC->page_content [ 'SELECTIONA' ] = "";
$oFC->page_content [ 'SELECTIONB' ] = "";
switch ( $oFC->page_content [ 'MODE' ] ) {
	case 0:
		break;
	default: 
		$oFC->page_content [ 'SELECTIONA' ] = $oFC->gsm_opmaakSel ( array ( 10 ) );
		if ( $oFC->page_content [ 'aantal' ]  ?? 0 > $oFC->setting [ 'qty_max' ] ) 
			$oFC->page_content [ 'SELECTIONB' ] = $oFC->gsm_opmaakSel ( array ( 13), "-", "-", $oFC->page_content [ 'position' ], $oFC->page_content [ 'aantal' ] , $oFC->setting [ 'qty_max' ]  );
		break;
} 
 
/* Output processing */
/* Memory save * /
$oFC->page_content ['MEMORY'] = $oFC->gsm_memorySaved ( ); 

/* Messages to show */
$oFC->page_content[ 'STATUS_MESSAGE' ] .= $oFC->description; 
if (strlen($oFC->page_content[ 'STATUS_MESSAGE' ])>4 ) $oFC->page_content['MESSAGE_CLASS']= "ui error message"; 
$oFC->page_content[ 'VERSIE' ] = $oFC->version; 
if (LOAD_MODE == "x" )  $_SESSION[ 'last_edit_section' ] = $section_id; 

/* Actual output */
echo $oTWIG->render( 
	$template_name, // template-filename
    $oFC->page_content // template-data
);
/* End output processing */

/* debug * /  Gsm_debug ($oFC->page_content, __LINE__ . $template_name ); 
if (LOAD_MODE == "x" )  Gsm_debug ($oFC->version, $template_name ); /* end */ 
?>